/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.util;

import com.clarkware.junitperf.LoadTest;
import com.clarkware.junitperf.TimedTest;
import java.util.Map;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.dom4j.util.PerThreadSingleton;
import org.dom4j.util.SingletonStrategy;

public class PerThreadSingletonTest
extends TestCase {
    private static SingletonStrategy singleton;
    private static ThreadLocal reference;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        reference = new ThreadLocal();
    }

    public PerThreadSingletonTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.util.PerThreadSingletonTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (singleton == null) {
                singleton = new PerThreadSingleton();
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("java.util.HashMap");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                singleton.setSingletonClassName(clazz3.getName());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInstance() throws Exception {
        String tid = Thread.currentThread().getName();
        Map map = (Map)singleton.instance();
        String expected = "new value";
        if (!map.containsKey(tid) && reference.get() != null) {
            System.out.println("tid=" + tid + " map=" + map);
            System.out.println("reference=" + reference);
            System.out.println("singleton=" + singleton);
            PerThreadSingletonTest.fail((String)"created singleton more than once");
        } else {
            map.put(tid, expected);
            reference.set(map);
        }
        String actual = (String)map.get(tid);
        PerThreadSingletonTest.assertEquals((String)"testInstance", (String)expected, (String)actual);
        map = (Map)singleton.instance();
        expected = "new value";
        actual = (String)map.get(tid);
        PerThreadSingletonTest.assertEquals((String)"testInstance", (String)expected, (String)actual);
        PerThreadSingletonTest.assertEquals((String)"testInstance reference", reference.get(), (Object)map);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(PerThreadSingletonTest.makeRepeatedLoadTest(5, 100, "testInstance"));
        return suite;
    }

    protected static Test makeRepeatedLoadTest(int users, int iterations, String testMethod) {
        long maxElapsedTime = 1200 + 1000 * users * iterations;
        PerThreadSingletonTest testCase = new PerThreadSingletonTest(testMethod);
        RepeatedTest repeatedTest = new RepeatedTest((Test)testCase, iterations);
        LoadTest loadTest = new LoadTest((Test)repeatedTest, users);
        TimedTest timedTest = new TimedTest((Test)loadTest, maxElapsedTime);
        return timedTest;
    }
}

