/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.dtd.ElementDecl;
import org.dom4j.io.SAXReader;

public class DocTypeTest
extends AbstractTestCase {
    protected static final String INPUT_XML_FILE = "/xml/dtd/internal.xml";
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.DocTypeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDocType() throws Exception {
        SAXReader reader = new SAXReader();
        reader.setIncludeInternalDTDDeclarations(true);
        Document document = this.getDocument(INPUT_XML_FILE, reader);
        DocumentType docType = document.getDocType();
        DocTypeTest.assertTrue((String)"Has DOCTYPE", (docType != null ? 1 : 0) != 0);
        List declarations = docType.getInternalDeclarations();
        DocTypeTest.assertTrue((String)"DOCTYPE has declarations", (declarations != null && !declarations.isEmpty() ? 1 : 0) != 0);
        ElementDecl decl = (ElementDecl)declarations.get(0);
        DocTypeTest.assertEquals((String)"name is correct", (String)"greeting", (String)decl.getName());
        DocTypeTest.assertEquals((String)"model is correct", (String)"(#PCDATA)", (String)decl.getModel());
        String expected = "<!ELEMENT " + decl.getName() + " " + decl.getModel() + ">";
        DocTypeTest.assertEquals((String)"toString() is correct", (String)expected, (String)decl.toString());
    }
}

