/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XMLSpaceAttributeTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.XMLSpaceAttributeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testWithTextTrimOn() throws Exception {
        String xmlString = "<top ><row><col>   This is a test!</col></row><row><col xml:space='preserve' >   This is a test!</col></row><row><col>   This is a test!</col></row></top>";
        Document doc1 = DocumentHelper.parseText(xmlString);
        Element c2 = (Element)doc1.selectSingleNode("/top/row[2]/col");
        String expected = "   New Text TrimOn! ";
        c2.setText(expected);
        String xml = this.rewriteToXmlString(doc1, true);
        Document doc2 = DocumentHelper.parseText(xml);
        Element c4 = (Element)doc2.selectSingleNode("/top/row[2]/col");
        String actual = c4.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text expecting whitespace", (String)expected, (String)actual);
        expected = expected.trim();
        actual = c4.getTextTrim();
        XMLSpaceAttributeTest.assertEquals((String)"compared element getTextTrim", (String)expected, (String)actual);
        expected = "This is a test!";
        Element c5 = (Element)doc2.selectSingleNode("/top/row[3]/col");
        actual = c5.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text expecting trimmed whitespace", (String)expected, (String)actual);
    }

    public void testWithTextTrimOff() throws Exception {
        String xmlString = "<top ><row><col>   This is a test!</col></row><row><col xml:space='preserve' >   This is a test!</col></row><row><col>   This is a test!</col></row></top>";
        Document doc1 = DocumentHelper.parseText(xmlString);
        Element c2 = (Element)doc1.selectSingleNode("/top/row[2]/col");
        String expected = "   New Text TrimOff! ";
        c2.setText(expected);
        String xml = this.rewriteToXmlString(doc1, false);
        Document doc2 = DocumentHelper.parseText(xml);
        Element c4 = (Element)doc2.selectSingleNode("/top/row[2]/col");
        String actual = c4.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text expecting whitespace", (String)expected, (String)actual);
    }

    public void testWithTextTrimOnFollow() throws Exception {
        String xmlString = "<top ><row><col>   This is a test!</col></row><row><col xml:space='preserve' ><a><b>   This is embedded!</b></a><a><b>   This is space=preserve too!</b></a></col></row><row><col>   This is a test!</col></row></top>";
        Document doc1 = DocumentHelper.parseText(xmlString);
        Element c2 = (Element)doc1.selectSingleNode("/top/row[2]/col/a[1]/b");
        String expected = "   New Text TrimOnFollow! ";
        c2.setText(expected);
        String xml = this.rewriteToXmlString(doc1, true);
        Document doc2 = DocumentHelper.parseText(xml);
        Element c4 = (Element)doc2.selectSingleNode("/top/row[2]/col/a[1]/b");
        String actual = c4.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text expecting whitespace", (String)expected, (String)actual);
        Element c8 = (Element)doc2.selectSingleNode("/top/row[2]/col/a[2]/b");
        expected = "   This is space=preserve too!";
        actual = c8.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text follow trimmed whitespace", (String)expected, (String)actual);
        expected = expected.trim();
        actual = c8.getTextTrim();
        XMLSpaceAttributeTest.assertEquals((String)"compared element getTextTrim", (String)expected, (String)actual);
        Element c12 = (Element)doc2.selectSingleNode("/top/row[3]/col");
        expected = "This is a test!";
        actual = c12.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text follow trimmed whitespace", (String)expected, (String)actual);
    }

    public void testWithTextTrimOnNested() throws Exception {
        String xmlString = "<top ><row><col>   This is a test!</col></row><row><col xml:space='preserve' ><a><b>   This is embedded! </b><b xml:space='default' >   This should do global default! </b><b>   This is embedded! </b></a></col></row><row><col>   This is a test!</col></row></top>";
        Document doc1 = DocumentHelper.parseText(xmlString);
        Element c2 = (Element)doc1.selectSingleNode("/top/row[2]/col/a[1]/b");
        String expected = "   New Text TrimOnNested! ";
        c2.setText(expected);
        String xml = this.rewriteToXmlString(doc1, true);
        Document doc2 = DocumentHelper.parseText(xml);
        Element c4 = (Element)doc2.selectSingleNode("/top/row[2]/col/a[1]/b[1]");
        String actual = c4.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text expecting whitespace", (String)expected, (String)actual);
        Element c8 = (Element)doc2.selectSingleNode("/top/row[2]/col/a[1]/b[2]");
        expected = "This should do global default!";
        actual = c8.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text nested trimmed whitespace", (String)expected, (String)actual);
        Element c12 = (Element)doc2.selectSingleNode("/top/row[2]/col/a[1]/b[3]");
        expected = "   This is embedded! ";
        actual = c12.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text nested preserved whitespace", (String)expected, (String)actual);
    }

    private String rewriteToXmlString(Document doc, boolean trimOn) throws IOException {
        OutputFormat of = OutputFormat.createCompactFormat();
        of.setIndent(true);
        of.setNewlines(true);
        of.setExpandEmptyElements(false);
        of.setSuppressDeclaration(false);
        of.setOmitEncoding(false);
        of.setEncoding("UTF-8");
        of.setTrimText(trimOn);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(os);
        XMLWriter xmlWriter = new XMLWriter(of);
        xmlWriter.setOutputStream(bos);
        xmlWriter.write(doc);
        xmlWriter.close();
        String xml = os.toString();
        return xml;
    }

    public void testWithEscapeTextTrimOn() throws Exception {
        String xmlString = "<top ><row><col>   This is a test!</col></row><row><col xml:space='preserve' >   This is a test!\r\nWith a new line, special character like &amp; , and\t tab.</col></row><row><col>   This is a test!\r\nWith a new line, special character like &amp; , and\t tab.</col></row></top>";
        Document doc1 = DocumentHelper.parseText(xmlString);
        String xml = this.rewriteToXmlString(doc1, true);
        Document doc2 = DocumentHelper.parseText(xml);
        Element c2 = (Element)doc2.selectSingleNode("/top/row[2]/col");
        String expected = "   This is a test!\nWith a new line, special character like & , and\t tab.";
        String actual = c2.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text expecting whitespace", (String)expected, (String)actual);
        Element c4 = (Element)doc2.selectSingleNode("/top/row[3]/col");
        expected = "This is a test! With a new line, special character like & , and tab.";
        actual = c4.getText();
        XMLSpaceAttributeTest.assertEquals((String)"compared element text expecting whitespace", (String)expected, (String)actual);
    }
}

