/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.StringWriter;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class LineFeedTest
extends AbstractTestCase {
    private static final String ATT_TEXT = "Hello&#xa;There&#xa;&lt;&gt;&amp;";
    private static final String TEXT = "Hello\nThere\n&lt;&gt;&amp;";
    private static final String EXPECTED_TEXT = "Hello\nThere\n<>&";
    private static final String EXPECTED_ATT_TEXT = "Hello There <>&";
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.LineFeedTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testElement() throws Exception {
        Document doc = DocumentHelper.parseText("<elem>Hello\nThere\n&lt;&gt;&amp;</elem>");
        Element elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_TEXT, (String)elem.getText());
    }

    public void testAttribute() throws Exception {
        Document doc = DocumentHelper.parseText("<elem attr=\"Hello\nThere\n&lt;&gt;&amp;\"/>");
        Element elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_ATT_TEXT, (String)elem.attributeValue("attr"));
        doc = DocumentHelper.parseText("<elem attr=\"Hello&#xa;There&#xa;&lt;&gt;&amp;\"/>");
        elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_TEXT, (String)elem.attributeValue("attr"));
    }

    public void testCDATA() throws Exception {
        Document doc = DocumentHelper.parseText("<elem><![CDATA[Hello\nThere\n<>&]]></elem>");
        Element elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_TEXT, (String)elem.getText());
    }

    public void testXmlWriter() throws Exception {
        Element elem = DocumentHelper.createElement("elem");
        Document doc = DocumentHelper.createDocument(elem);
        elem.addCDATA(EXPECTED_TEXT);
        StringWriter sw = new StringWriter();
        XMLWriter xWriter = new XMLWriter(sw, OutputFormat.createPrettyPrint());
        xWriter.write(doc);
        xWriter.close();
        String xmlString = sw.toString();
        doc = DocumentHelper.parseText(xmlString);
        elem = doc.getRootElement();
        LineFeedTest.assertEquals((String)EXPECTED_TEXT, (String)elem.getText());
    }
}

