/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXContentHandler;
import org.xml.sax.XMLReader;

public class SAXContentHandlerTest
extends AbstractTestCase {
    private XMLReader xmlReader;
    protected String[] testDocuments = new String[]{"/xml/test/test_schema.xml", "/xml/test/encode.xml", "/xml/fibo.xml", "/xml/test/schema/personal-prefix.xsd", "/xml/test/soap2.xml"};
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.SAXContentHandlerTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser parser = spf.newSAXParser();
        this.xmlReader = parser.getXMLReader();
    }

    public void testSAXContentHandler() throws Exception {
        SAXContentHandler contentHandler = new SAXContentHandler();
        this.xmlReader.setContentHandler(contentHandler);
        this.xmlReader.setDTDHandler(contentHandler);
        this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        int i = 0;
        int size = this.testDocuments.length;
        while (i < size) {
            Document docFromSAXReader = this.getDocument(this.testDocuments[i]);
            this.xmlReader.parse(this.getFile(this.testDocuments[i]).toString());
            Document docFromSAXContentHandler = contentHandler.getDocument();
            docFromSAXContentHandler.setName(docFromSAXReader.getName());
            this.assertDocumentsEqual(docFromSAXReader, docFromSAXContentHandler);
            SAXContentHandlerTest.assertEquals((String)docFromSAXReader.asXML(), (String)docFromSAXContentHandler.asXML());
            ++i;
        }
    }

    public void testBug926713() throws Exception {
        Document doc = this.getDocument("/xml/test/cdata.xml");
        Element foo = doc.getRootElement();
        Element bar = foo.element("bar");
        List content = bar.content();
        SAXContentHandlerTest.assertEquals((int)3, (int)content.size());
        SAXContentHandlerTest.assertEquals((short)3, (short)((Node)content.get(0)).getNodeType());
        SAXContentHandlerTest.assertEquals((short)4, (short)((Node)content.get(1)).getNodeType());
        SAXContentHandlerTest.assertEquals((short)3, (short)((Node)content.get(2)).getNodeType());
    }
}

