/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class MakeElementTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.MakeElementTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testMakeElement() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element c = DocumentHelper.makeElement(doc, "a/b/c");
        MakeElementTest.assertTrue((String)"Should return a valid element", (c != null ? 1 : 0) != 0);
        Element c2 = DocumentHelper.makeElement(doc, "a/b/c");
        MakeElementTest.assertTrue((String)"Found same element again", (c == c2 ? 1 : 0) != 0);
        c.addAttribute("x", "123");
        Node found = doc.selectSingleNode("/a/b/c[@x='123']");
        MakeElementTest.assertEquals((String)"Found same node via XPath", (Object)c, (Object)found);
        Element b = c.getParent();
        Element e = DocumentHelper.makeElement(b, "c/d/e");
        MakeElementTest.assertTrue((String)"Should return a valid element", (e != null ? 1 : 0) != 0);
        Element e2 = DocumentHelper.makeElement(b, "c/d/e");
        MakeElementTest.assertTrue((String)"Found same element again", (e == e2 ? 1 : 0) != 0);
        e.addAttribute("y", "456");
        found = b.selectSingleNode("c/d/e[@y='456']");
        MakeElementTest.assertEquals((String)"Found same node via XPath", (Object)e, (Object)found);
    }

    public void testMakeQualifiedElement() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("root");
        root.addNamespace("", "defaultURI");
        root.addNamespace("foo", "fooURI");
        root.addNamespace("bar", "barURI");
        Element c = DocumentHelper.makeElement(doc, "root/foo:b/bar:c");
        MakeElementTest.assertTrue((String)"Should return a valid element", (c != null ? 1 : 0) != 0);
        MakeElementTest.assertEquals((String)"c has a valid namespace", (String)"barURI", (String)c.getNamespaceURI());
        Element b = c.getParent();
        MakeElementTest.assertEquals((String)"b has a valid namespace", (String)"fooURI", (String)b.getNamespaceURI());
        this.log("Created: " + c);
        Element c2 = DocumentHelper.makeElement(doc, "root/foo:b/bar:c");
        MakeElementTest.assertTrue((String)"Found same element again", (c == c2 ? 1 : 0) != 0);
    }
}

