/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dtd;

import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.dtd.AttributeDecl;

public class AttributeDeclTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.dtd.AttributeDeclTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testIdImpliedNone() {
        MyTestAttributeDecl decl = new MyTestAttributeDecl("foo", "bar", "ID", "#IMPLIED", null, "<!ATTLIST foo bar ID #IMPLIED>");
        this.assertSameAttributeDecl(decl, new AttributeDecl("foo", "bar", "ID", "#IMPLIED", null));
    }

    public void testCDataFixedValue() {
        MyTestAttributeDecl decl = new MyTestAttributeDecl("foo", "bar", "CDATA", "#FIXED", "goo", "<!ATTLIST foo bar CDATA #FIXED \"goo\">");
        this.assertSameAttributeDecl(decl, new AttributeDecl("foo", "bar", "CDATA", "#FIXED", "goo"));
    }

    public void testCDataNoneValue() {
        MyTestAttributeDecl decl = new MyTestAttributeDecl("foo", "bar", "CDATA", null, "goo", "<!ATTLIST foo bar CDATA \"goo\">");
        this.assertSameAttributeDecl(decl, new AttributeDecl("foo", "bar", "CDATA", null, "goo"));
    }

    protected void assertSameAttributeDecl(MyTestAttributeDecl expected, AttributeDecl actual) {
        AttributeDeclTest.assertEquals((String)"elementName is correct", (String)expected.getElementName(), (String)actual.getElementName());
        AttributeDeclTest.assertEquals((String)"attributeName is correct", (String)expected.getAttributeName(), (String)actual.getAttributeName());
        AttributeDeclTest.assertEquals((String)"type is correct", (String)expected.getType(), (String)actual.getType());
        AttributeDeclTest.assertEquals((String)"valueDefault is correct", (String)expected.getValueDefault(), (String)actual.getValueDefault());
        AttributeDeclTest.assertEquals((String)"toString() is correct", (String)expected.getText(), (String)actual.toString());
    }

    protected static class MyTestAttributeDecl {
        private String elName;
        private String attName;
        private String declType;
        private String defaultValue;
        private String declValue;
        private String txt;

        public MyTestAttributeDecl(String elementName, String attributeName, String type, String valueDefault, String value, String text) {
            this.elName = elementName;
            this.attName = attributeName;
            this.declType = type;
            this.defaultValue = valueDefault;
            this.declValue = value;
            this.txt = text;
        }

        public String getElementName() {
            return this.elName;
        }

        public String getAttributeName() {
            return this.attName;
        }

        public String getType() {
            return this.declType;
        }

        public String getValueDefault() {
            return this.defaultValue;
        }

        public String getValue() {
            return this.declValue;
        }

        public String getText() {
            return this.txt;
        }
    }
}

