/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.Iterator;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;

public class MergeTextTest
extends AbstractTestCase {
    private static final String INPUT_XML_FILE = "/xml/test/mergetext.xml";
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.MergeTextTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testNoAdjacentText() throws Exception {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        Document document = this.getDocument(INPUT_XML_FILE, reader);
        this.checkNoAdjacent(document.getRootElement());
        this.log("No adjacent Text nodes in " + document.asXML());
    }

    private void checkNoAdjacent(Element parent) {
        Node prev = null;
        Iterator iter = parent.nodeIterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            if (n instanceof Text && prev != null && prev instanceof Text) {
                MergeTextTest.fail((String)("Node: " + n + " is text and so is its " + "preceding sibling: " + prev));
            } else if (n instanceof Element) {
                this.checkNoAdjacent((Element)n);
            }
            prev = n;
        }
    }
}

