/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;

public class AttributeTest
extends AbstractTestCase {
    protected static String[] paths = new String[]{"attribute::*", "/root/author/attribute::*", "//attribute::*", "@name"};
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.xpath.AttributeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testXPaths() throws Exception {
        int size = paths.length;
        int i = 0;
        while (i < size) {
            this.testXPath(paths[i]);
            ++i;
        }
    }

    protected void testXPath(String xpathText) {
        XPath xpath = DocumentHelper.createXPath(xpathText);
        List list = xpath.selectNodes(this.document);
        this.log("Searched path: " + xpathText + " found: " + list.size() + " result(s)");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            this.log("Found Result: " + object);
            AttributeTest.assertTrue((String)"Results should be Attribute objects", (boolean)(object instanceof Attribute));
            Attribute attribute = (Attribute)object;
            AttributeTest.assertTrue((String)"Results should support the parent relationship", (boolean)attribute.supportsParent());
            AttributeTest.assertTrue((String)"Results should contain reference to the parent element", (attribute.getParent() != null ? 1 : 0) != 0);
            AttributeTest.assertTrue((String)"Resulting document not correct", (attribute.getDocument() != null ? 1 : 0) != 0);
        }
    }
}

