/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class NamespaceTest
extends AbstractTestCase {
    private static final String INPUT_XML_FILE = "/xml/namespaces.xml";
    private static final Namespace XSL_NAMESPACE = Namespace.get("xsl", "http://www.w3.org/1999/XSL/Transform");
    private static final QName XSL_TEMPLATE = QName.get("template", XSL_NAMESPACE);
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.NamespaceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void debugShowNamespaces() throws Exception {
        Element root = this.getRootElement();
        Iterator iter = root.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            this.log("Found element:    " + element);
            this.log("Namespace:        " + element.getNamespace());
            this.log("Namespace prefix: " + element.getNamespacePrefix());
            this.log("Namespace URI:    " + element.getNamespaceURI());
        }
    }

    public void testGetElement() throws Exception {
        Element root = this.getRootElement();
        Element firstTemplate = root.element(XSL_TEMPLATE);
        NamespaceTest.assertTrue((String)"Root element contains at least one <xsl:template/> element", (firstTemplate != null ? 1 : 0) != 0);
        this.log("Found element: " + firstTemplate);
    }

    public void testGetElements() throws Exception {
        Element root = this.getRootElement();
        List list = root.elements(XSL_TEMPLATE);
        NamespaceTest.assertTrue((String)"Root element contains at least one <xsl:template/> element", (list.size() > 0 ? 1 : 0) != 0);
        this.log("Found elements: " + list);
    }

    public void testElementIterator() throws Exception {
        Element root = this.getRootElement();
        Iterator iter = root.elementIterator(XSL_TEMPLATE);
        NamespaceTest.assertTrue((String)"Root element contains at least one <xsl:template/> element", (boolean)iter.hasNext());
        do {
            Element element = (Element)iter.next();
            this.log("Found element: " + element);
        } while (iter.hasNext());
    }

    public void testNamespaceUriMap() throws Exception {
        HashMap<String, String> uris = new HashMap<String, String>();
        uris.put("x", "fooNamespace");
        uris.put("y", "barNamespace");
        DocumentFactory factory = new DocumentFactory();
        factory.setXPathNamespaceURIs(uris);
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory(factory);
        Document doc = this.getDocument("/xml/test/nestedNamespaces.xml", reader);
        String value = doc.valueOf("/x:pizza/y:cheese/x:pepper");
        this.log("Found value: " + value);
        NamespaceTest.assertEquals((String)"XPath used default namesapce URIS", (String)"works", (String)value);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.document = this.getDocument(INPUT_XML_FILE);
    }

    protected Element getRootElement() {
        Element root = this.document.getRootElement();
        NamespaceTest.assertTrue((String)"Document has root element", (root != null ? 1 : 0) != 0);
        return root;
    }
}

