/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.rule.Action;
import org.dom4j.rule.Pattern;
import org.dom4j.rule.Rule;
import org.dom4j.rule.Stylesheet;
import org.dom4j.xpath.DefaultXPath;

public class StylesheetTest
extends AbstractTestCase {
    protected String[] templates = new String[]{"/", "*", "root", "author", "@name", "root/author", "author[@location='UK']", "root/author[@location='UK']", "root//author[@location='UK']"};
    protected String[] templates2 = new String[]{"/", "title", "para", "*"};
    protected Stylesheet stylesheet;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.rule.StylesheetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testRules() throws Exception {
        int i = 0;
        int size = this.templates.length;
        while (i < size) {
            this.addTemplate(this.templates[i]);
            ++i;
        }
        this.log("");
        this.log("........................................");
        this.log("");
        this.log("Running stylesheet");
        this.stylesheet.run(this.document);
        this.log("Finished");
    }

    public void testLittleDoc() throws Exception {
        int i = 0;
        int size = this.templates2.length;
        while (i < size) {
            this.addTemplate(this.templates2[i]);
            ++i;
        }
        Document doc = this.getDocument("/xml/test/littledoc.xml");
        this.stylesheet = new Stylesheet();
        this.stylesheet.setValueOfAction(new Action(){

            public void run(Node node) {
                StylesheetTest.this.log("Default ValueOf action on node: " + node);
                StylesheetTest.this.log("........................................");
            }
        });
        this.stylesheet.run(doc);
    }

    public void testFireRuleForNode() throws Exception {
        final StringBuffer b = new StringBuffer();
        final Stylesheet s = new Stylesheet();
        Pattern pattern = DocumentHelper.createPattern("url");
        Action action = new Action(){

            public void run(Node node) throws Exception {
                b.append("url");
                s.applyTemplates(node);
            }
        };
        Rule r = new Rule(pattern, action);
        s.addRule(r);
        s.applyTemplates((Object)this.document, new DefaultXPath("root/author/url"));
        StylesheetTest.assertEquals((String)"Check url is processed twice", (String)"urlurl", (String)b.toString());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.stylesheet = new Stylesheet();
        this.stylesheet.setValueOfAction(new Action(){

            public void run(Node node) {
                StylesheetTest.this.log("Default ValueOf action on node: " + node);
                StylesheetTest.this.log("........................................");
            }
        });
    }

    protected void addTemplate(final String match) {
        this.log("Adding template match: " + match);
        Pattern pattern = DocumentHelper.createPattern(match);
        this.log("Pattern: " + pattern);
        this.log("........................................");
        Action action = new Action(){

            public void run(Node node) throws Exception {
                StylesheetTest.this.log("Matched pattern: " + match);
                StylesheetTest.this.log("Node: " + node.asXML());
                StylesheetTest.this.log("........................................");
                StylesheetTest.this.stylesheet.applyTemplates(node);
            }
        };
        Rule rule = new Rule(pattern, action);
        this.stylesheet.addRule(rule);
    }
}

