/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.Iterator;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public class NodeTypeNameTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.NodeTypeNameTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDocument() throws Exception {
        this.testDocument(this.getDocument());
    }

    public void testCDATA() throws Exception {
        this.testDocument("/xml/cdata.xml");
    }

    public void testNamespaces() throws Exception {
        this.testDocument("/xml/namespaces.xml");
        this.testDocument("/xml/testNamespaces.xml");
    }

    public void testPI() throws Exception {
        this.testDocument("/xml/testPI.xml");
    }

    public void testInline() throws Exception {
        this.testDocument("/xml/inline.xml");
    }

    protected void testDocument(String fileName) throws Exception {
        Document document = this.getDocument(fileName);
        this.testDocument(document);
    }

    protected void testDocument(Document document) throws Exception {
        NodeTypeNameTest.assertEquals((String)document.getNodeTypeName(), (String)"Document");
        DocumentType docType = document.getDocType();
        if (docType != null) {
            NodeTypeNameTest.assertEquals((String)docType.getNodeTypeName(), (String)"DocumentType");
        }
        this.testElement(document.getRootElement());
    }

    protected void testElement(Element element) {
        NodeTypeNameTest.assertEquals((String)element.getNodeTypeName(), (String)"Element");
        Iterator iter = element.attributeIterator();
        while (iter.hasNext()) {
            Attribute attribute = (Attribute)iter.next();
            NodeTypeNameTest.assertEquals((String)attribute.getNodeTypeName(), (String)"Attribute");
        }
        iter = element.nodeIterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            String nodeTypeName = node.getNodeTypeName();
            if (node instanceof Attribute) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Attribute");
                continue;
            }
            if (node instanceof CDATA) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"CDATA");
                continue;
            }
            if (node instanceof Comment) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Comment");
                continue;
            }
            if (node instanceof Element) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Element");
                this.testElement((Element)node);
                continue;
            }
            if (node instanceof Entity) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Entity");
                continue;
            }
            if (node instanceof Element) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Element");
                continue;
            }
            if (node instanceof Namespace) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Namespace");
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"ProcessingInstruction");
                continue;
            }
            if (node instanceof Text) {
                NodeTypeNameTest.assertEquals((String)nodeTypeName, (String)"Text");
                continue;
            }
            NodeTypeNameTest.assertTrue((String)("Invalid node type: " + nodeTypeName + " for node: " + node), (boolean)false);
        }
    }
}

