/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import com.clarkware.junitperf.LoadTest;
import com.clarkware.junitperf.TimedTest;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ThreadingTest
extends AbstractTestCase {
    private static final ThreadLocal FORMATTER_CACHE = new ThreadLocal();
    private static final String SEPERATOR = " - ";
    private static final FieldPosition FIELD_ZERO = new FieldPosition(0);
    static /* synthetic */ Class class$0;

    public ThreadingTest(String name) {
        super(name);
    }

    private static void preformat(StringBuffer strBuf, String context) {
        long now = System.currentTimeMillis();
        Date currentTime = new Date(now);
        SimpleDateFormat formatter = (SimpleDateFormat)FORMATTER_CACHE.get();
        if (formatter == null) {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS zzz");
            FORMATTER_CACHE.set(formatter);
        }
        strBuf.append("[");
        formatter.format(currentTime, strBuf, FIELD_ZERO);
        strBuf.append(" (").append(now).append(") ]");
        strBuf.append(SEPERATOR);
        strBuf.append(ThreadingTest.getThreadId());
        strBuf.append(SEPERATOR);
        strBuf.append(context);
        strBuf.append(SEPERATOR);
    }

    private static String getThreadId() {
        String tid = Thread.currentThread().getName();
        return tid;
    }

    public void testCombo() {
        int loop = 10;
        try {
            long begin = System.currentTimeMillis();
            String value = null;
            String expected = null;
            String xml = null;
            Document doc = null;
            Element root = null;
            Element item = null;
            Element newItem = null;
            QName qn = null;
            Namespace ns = null;
            long now = 0L;
            xml = "<ROOT xmlns:t0=\"http://www.lse.com/t0\" >  <ctx><type>Context</type></ctx>  <A><B><C><D>This is a TEST</D></C></B></A>  <t0:Signon><A>xyz</A><t0:Cust>customer</t0:Cust></t0:Signon></ROOT>";
            int i = 0;
            while (i < loop) {
                doc = DocumentHelper.parseText(xml);
                root = doc.getRootElement();
                ns = Namespace.get("t0", "http://www.lse.com/t0");
                qn = QName.get("Signon", ns);
                item = root.element(qn);
                value = item.asXML();
                expected = "<t0:Signon xmlns:t0=\"http://www.lse.com/t0\"><A>xyz</A><t0:Cust>customer</t0:Cust></t0:Signon>";
                ThreadingTest.assertEquals((String)"test t0:Signon ", (String)expected, (String)value);
                qn = root.getQName("Test");
                newItem = DocumentHelper.createElement(qn);
                now = System.currentTimeMillis();
                newItem.setText(String.valueOf(now));
                root.add(newItem);
                qn = root.getQName("Test2");
                newItem = DocumentHelper.createElement(qn);
                now = System.currentTimeMillis();
                newItem.setText(String.valueOf(now));
                root.add(newItem);
                item = root.element(qn);
                item.detach();
                item.setQName(qn);
                root.add(item);
                value = item.asXML();
                expected = "<Test2>" + now + "</Test2>";
                ThreadingTest.assertEquals((String)"test Test2 ", (String)expected, (String)value);
                qn = root.getQName("Test3");
                newItem = DocumentHelper.createElement(qn);
                now = System.currentTimeMillis();
                newItem.setText(String.valueOf(now));
                root.add(newItem);
                item = root.element(qn);
                item.detach();
                item.setQName(qn);
                root.add(item);
                value = item.asXML();
                expected = "<Test3>" + now + "</Test3>";
                ThreadingTest.assertEquals((String)"test Test3 ", (String)expected, (String)value);
                qn = item.getQName("Test4");
                newItem = DocumentHelper.createElement(qn);
                now = System.currentTimeMillis();
                newItem.setText(String.valueOf(now));
                root.add(newItem);
                item = root.element(qn);
                item.detach();
                item.setQName(qn);
                root.add(item);
                value = item.asXML();
                expected = "<Test4>" + now + "</Test4>";
                ThreadingTest.assertEquals((String)"test Test4 ", (String)expected, (String)value);
                ++i;
            }
            double duration = System.currentTimeMillis() - begin;
            double avg = duration / (double)loop;
        }
        catch (Exception e) {
            e.printStackTrace();
            ThreadingTest.assertTrue((String)("Exception in test: " + e.getMessage()), (boolean)false);
        }
    }

    public void testQNameCache() {
        int loop = 100;
        try {
            long begin = System.currentTimeMillis();
            String value = null;
            String expected = null;
            String xml = null;
            Document doc = null;
            Element root = null;
            Object item = null;
            Object newItem = null;
            QName qn = null;
            Object ns = null;
            long now = 0L;
            xml = "<ROOT xmlns:t0=\"http://www.lse.com/t0\" >  <ctx><type>Context</type></ctx>  <A><B><C><D>This is a TEST</D></C></B></A>  <t0:Signon><A>xyz</A><t0:Cust>customer</t0:Cust></t0:Signon></ROOT>";
            int i = 0;
            while (i < loop) {
                doc = DocumentHelper.parseText(xml);
                root = doc.getRootElement();
                qn = DocumentHelper.createQName("test");
                value = this.fetchValue(qn);
                expected = "<test/>";
                ThreadingTest.assertEquals((String)"test test ", (String)expected, (String)value);
                qn = DocumentHelper.createQName("test");
                value = this.fetchValue(qn);
                expected = "<test/>";
                ThreadingTest.assertEquals((String)"test test again ", (String)expected, (String)value);
                qn = root.getQName("t0:Signon");
                value = this.fetchValue(qn);
                expected = "<t0:Signon xmlns:t0=\"http://www.lse.com/t0\"/>";
                ThreadingTest.assertEquals((String)"test t0:Signon ", (String)expected, (String)value);
                ++i;
            }
            double duration = System.currentTimeMillis() - begin;
            double avg = duration / (double)loop;
        }
        catch (Exception e) {
            e.printStackTrace();
            ThreadingTest.assertTrue((String)("Exception in test: " + e.getMessage()), (boolean)false);
        }
    }

    public String fetchValue(QName qn) {
        String value = null;
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        String prefix = qn.getNamespacePrefix();
        if (prefix != null && prefix.length() > 0) {
            sb.append(prefix).append(":");
        }
        sb.append(qn.getName());
        String uri = qn.getNamespaceURI();
        if (uri != null && uri.length() > 0) {
            sb.append(" xmlns");
            if (prefix != null && prefix.length() > 0) {
                sb.append(":").append(prefix);
            }
            sb.append("=\"").append(uri).append("\"");
        }
        sb.append("/>");
        value = sb.toString();
        return value;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(ThreadingTest.makeRepeatedLoadTest(5, 10, "testCombo"));
        suite.addTest(ThreadingTest.makeRepeatedLoadTest(5, 10, "testQNameCache"));
        return suite;
    }

    protected static Test makeRepeatedLoadTest(int users, int iterations, String testMethod) {
        long maxElapsedTime = 120000 + 1000 * users * iterations;
        ThreadingTest testCase = new ThreadingTest(testMethod);
        RepeatedTest repeatedTest = new RepeatedTest((Test)testCase, iterations);
        LoadTest loadTest = new LoadTest((Test)repeatedTest, users);
        TimedTest timedTest = new TimedTest((Test)loadTest, maxElapsedTime);
        return timedTest;
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.ThreadingTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }
}

