/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPathException;
import org.dom4j.io.SAXReader;
import org.dom4j.rule.Pattern;

public class XPathExamplesTest
extends AbstractTestCase {
    protected SAXReader xmlReader = new SAXReader();
    protected Document testDocument;
    protected Node testContext;
    protected DocumentFactory factory = DocumentFactory.getInstance();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.XPathExamplesTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testXPaths() throws Exception {
        Document document = this.getDocument("/xml/test/xpath/tests.xml");
        Element root = document.getRootElement();
        Iterator iter = root.elementIterator("document");
        while (iter.hasNext()) {
            Element documentTest = (Element)iter.next();
            this.testDocument(documentTest);
        }
    }

    protected void testDocument(Element documentTest) throws Exception {
        String url = documentTest.attributeValue("url");
        this.testDocument = this.xmlReader.read(this.getFile(url));
        XPathExamplesTest.assertTrue((String)("Loaded test document: " + url), (this.testDocument != null ? 1 : 0) != 0);
        this.log("Loaded document: " + url);
        Iterator iter = documentTest.elementIterator("context");
        while (iter.hasNext()) {
            Element context = (Element)iter.next();
            this.testContext(documentTest, context);
        }
    }

    protected void testContext(Element documentTest, Element context) throws Exception {
        String xpath = context.attributeValue("select");
        List list = this.testDocument.selectNodes(xpath);
        XPathExamplesTest.assertTrue((String)("Found at least one context nodes to test for path: " + xpath), (list != null && list.size() > 0 ? 1 : 0) != 0);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            XPathExamplesTest.assertTrue((String)("Context node is a Node: " + object), (boolean)(object instanceof Node));
            this.testContext = (Node)object;
            this.log("Context is now: " + this.testContext);
            this.runTests(documentTest, context);
            this.log("");
        }
    }

    protected void runTests(Element documentTest, Element context) throws Exception {
        Iterator iter = context.elementIterator("test");
        while (iter.hasNext()) {
            Element test = (Element)iter.next();
            this.runTest(documentTest, context, test);
        }
        Iterator it = context.elementIterator("valueOf");
        while (it.hasNext()) {
            Element valueOf = (Element)it.next();
            this.testValueOf(documentTest, context, valueOf);
        }
        it = context.elementIterator("pattern");
        while (it.hasNext()) {
            Element pattern = (Element)it.next();
            this.testPattern(documentTest, context, pattern);
        }
        it = context.elementIterator("fileter");
        while (it.hasNext()) {
            Element filter = (Element)it.next();
            this.testFilter(documentTest, context, filter);
        }
    }

    protected void runTest(Element documentTest, Element context, Element test) throws Exception {
        Element valueOf;
        String count;
        String xpath = test.attributeValue("select");
        String description = "Path: " + xpath;
        String exception = test.attributeValue("exception");
        if (exception != null && exception.equals("true")) {
            try {
                this.testContext.selectNodes(xpath);
                XPathExamplesTest.fail((String)"Exception was not thrown");
            }
            catch (XPathException e) {
                return;
            }
        }
        if ((count = test.attributeValue("count")) != null) {
            int expectedSize = Integer.parseInt(count);
            List results = this.testContext.selectNodes(xpath);
            this.log(String.valueOf(description) + " found result size: " + results.size());
            XPathExamplesTest.assertEquals((String)(String.valueOf(description) + " wrong result size"), (int)expectedSize, (int)results.size());
        }
        if ((valueOf = test.element("valueOf")) != null) {
            Node node = this.testContext.selectSingleNode(xpath);
            XPathExamplesTest.assertTrue((String)(String.valueOf(description) + " found node"), (node != null ? 1 : 0) != 0);
            String expected = valueOf.getText();
            String result = node.valueOf(valueOf.attributeValue("select"));
            this.log(description);
            this.log("\texpected: " + expected + " result: " + result);
            XPathExamplesTest.assertEquals((String)description, (String)expected, (String)result);
        }
    }

    protected void testValueOf(Element documentTest, Element context, Element valueOf) throws Exception {
        String xpath = valueOf.attributeValue("select");
        String description = "valueOf: " + xpath;
        String expected = valueOf.getText();
        String result = this.testContext.valueOf(xpath);
        this.log(description);
        this.log("\texpected: " + expected + " result: " + result);
        XPathExamplesTest.assertEquals((String)description, (String)expected, (String)result);
    }

    protected void testPattern(Element documentTest, Element context, Element patternElement) throws Exception {
        String match = patternElement.attributeValue("match");
        String description = "match: " + match;
        this.log("");
        this.log(description);
        Pattern pattern = this.factory.createPattern(match);
        XPathExamplesTest.assertTrue((String)description, (boolean)pattern.matches(this.testContext));
    }

    protected void testFilter(Element documentTest, Element context, Element pattern) throws Exception {
        String match = pattern.attributeValue("match");
        String description = "match: " + match;
        XPathExamplesTest.assertTrue((String)description, (boolean)this.testContext.matches(match));
    }
}

