/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;

public class ContentTest
extends AbstractTestCase {
    protected DocumentFactory factory = new DocumentFactory();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.ContentTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testRoot() throws Exception {
        Element root = this.document.getRootElement();
        ContentTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        List authors = root.elements("author");
        ContentTest.assertTrue((String)"Root has children", (authors != null && authors.size() == 2 ? 1 : 0) != 0);
        Element author1 = (Element)authors.get(0);
        Element author2 = (Element)authors.get(1);
        ContentTest.assertTrue((String)"Author1 is James", (boolean)author1.attributeValue("name").equals("James"));
        ContentTest.assertTrue((String)"Author2 is Bob", (boolean)author2.attributeValue("name").equals("Bob"));
        this.testGetAttributes(author1);
        this.testGetAttributes(author2);
    }

    public void testContent() throws Exception {
        Element root = this.document.getRootElement();
        ContentTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        List content = root.content();
        ContentTest.assertTrue((String)"Root has content", (content != null && content.size() >= 2 ? 1 : 0) != 0);
        boolean iterated = false;
        Iterator iter = content.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            ContentTest.assertTrue((String)"Content object is a node", (boolean)(object instanceof Node));
            iterated = true;
        }
        ContentTest.assertTrue((String)"Iteration completed", (boolean)iterated);
    }

    public void testGetNode() throws Exception {
        Element root = this.document.getRootElement();
        ContentTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        int count = root.nodeCount();
        ContentTest.assertTrue((String)"Root has correct node count", (count == 2 ? 1 : 0) != 0);
        boolean iterated = false;
        int i = 0;
        while (i < count) {
            Node node = root.node(i);
            ContentTest.assertTrue((String)"Valid node returned from node()", (node != null ? 1 : 0) != 0);
            iterated = true;
            ++i;
        }
        ContentTest.assertTrue((String)"Iteration completed", (boolean)iterated);
    }

    public void testGetXPathNode() throws Exception {
        Element root = this.document.getRootElement();
        ContentTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        int count = root.nodeCount();
        ContentTest.assertTrue((String)"Root has correct node count", (count == 2 ? 1 : 0) != 0);
        boolean iterated = false;
        int i = 0;
        while (i < count) {
            Node node = root.getXPathResult(i);
            ContentTest.assertTrue((String)"Valid node returned from node()", (node != null ? 1 : 0) != 0);
            ContentTest.assertTrue((String)"Node supports the parent relationship", (boolean)node.supportsParent());
            iterated = true;
            ++i;
        }
        ContentTest.assertTrue((String)"Iteration completed", (boolean)iterated);
    }

    public void testOrderOfPI() throws Exception {
        Document document = this.factory.createDocument();
        document.addProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"...\"");
        document.addElement("root");
        List list = document.content();
        ContentTest.assertNotNull((Object)list);
        ContentTest.assertEquals((int)2, (int)list.size());
        Object pi = list.get(0);
        Object root = list.get(1);
        ContentTest.assertTrue((String)"First element is not a PI", (boolean)(pi instanceof ProcessingInstruction));
        ContentTest.assertTrue((String)"Second element is an element", (boolean)(root instanceof Element));
        String xml = "<?xml version=\"1.0\" ?>\n<?xml-stylesheet type=\"text/xsl\" href=\"foo\" ?>\n<root/>";
        document = DocumentHelper.parseText(xml);
        list = document.content();
        ContentTest.assertNotNull((Object)list);
        ContentTest.assertEquals((int)2, (int)list.size());
        pi = list.get(0);
        root = list.get(1);
        ContentTest.assertTrue((String)"First element is not a PI", (boolean)(pi instanceof ProcessingInstruction));
        ContentTest.assertTrue((String)"Second element is an element", (boolean)(root instanceof Element));
    }

    public void testAddingInTheMiddle() throws Exception {
        Document doc = this.factory.createDocument();
        Element root = doc.addElement("html");
        Element header = root.addElement("header");
        Element footer = root.addElement("footer");
        List list = root.content();
        Element foo = this.factory.createElement("foo");
        list.add(1, foo);
        ContentTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        ContentTest.assertTrue((list.get(0) == header ? 1 : 0) != 0);
        ContentTest.assertTrue((list.get(1) == foo ? 1 : 0) != 0);
        ContentTest.assertTrue((list.get(2) == footer ? 1 : 0) != 0);
    }

    public void testAddAtIndex() throws Exception {
        Document doc = this.factory.createDocument();
        Element root = doc.addElement("html");
        Element header = root.addElement("header");
        Element body = root.addElement("body");
        Element foo = this.factory.createElement("foo");
        Element bar = this.factory.createElement("bar");
        List content = header.content();
        content.add(0, foo);
        content.add(0, bar);
        ContentTest.assertEquals((String)"foo", (String)header.node(1).getName());
        ContentTest.assertEquals((String)"bar", (String)header.node(0).getName());
        foo = this.factory.createElement("foo");
        bar = this.factory.createElement("bar");
        content = body.content();
        content.add(0, foo);
        content.add(1, bar);
        ContentTest.assertEquals((String)"foo", (String)body.node(0).getName());
        ContentTest.assertEquals((String)"bar", (String)body.node(1).getName());
    }

    public void testAddAtIndex2() throws Exception {
        Document doc = this.factory.createDocument();
        Element parent = doc.addElement("parent");
        Element child = parent.addElement("child");
        Element anotherChild = this.factory.createElement("child2");
        List elements = parent.elements();
        int index = elements.indexOf(child);
        ContentTest.assertEquals((int)0, (int)index);
        elements.add(1, anotherChild);
        elements = parent.elements();
        ContentTest.assertEquals((Object)child, elements.get(0));
        ContentTest.assertEquals((Object)anotherChild, elements.get(1));
    }

    protected void testGetAttributes(Element author) throws Exception {
        String definedName = "name";
        String undefinedName = "undefined-attribute-name";
        String defaultValue = "** Default Value **";
        String value = author.attributeValue(definedName, defaultValue);
        ContentTest.assertTrue((String)"Defined value doesn't return specified default value", (value != defaultValue ? 1 : 0) != 0);
        value = author.attributeValue(undefinedName, defaultValue);
        ContentTest.assertTrue((String)"Undefined value returns specified default value", (value == defaultValue ? 1 : 0) != 0);
    }
}

