/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class NamespaceTest
extends AbstractTestCase {
    protected static String[] paths = new String[]{"namespace::*", "/Template/Application1/namespace::*", "/Template/Application1/namespace::xplt", "//namespace::*"};
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.xpath.NamespaceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testXPaths() throws Exception {
        int size = paths.length;
        int i = 0;
        while (i < size) {
            this.testXPath(paths[i]);
            ++i;
        }
    }

    protected void testXPath(String xpathText) {
        XPath xpath = DocumentHelper.createXPath(xpathText);
        List list = xpath.selectNodes(this.document);
        this.log("Searched path: " + xpathText + " found: " + list.size() + " result(s)");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            this.log("Found Result: " + object);
            NamespaceTest.assertTrue((String)"Results should be Namespace objects", (boolean)(object instanceof Namespace));
            Namespace namespace = (Namespace)object;
            this.log("Parent node: " + namespace.getParent());
            NamespaceTest.assertTrue((String)"Results should support the parent relationship", (boolean)namespace.supportsParent());
            NamespaceTest.assertTrue((String)"Results should contain reference to the parent element", (namespace.getParent() != null ? 1 : 0) != 0);
            NamespaceTest.assertTrue((String)"Results should contain reference to the document", (namespace.getDocument() != null ? 1 : 0) != 0);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.document = new SAXReader().read(new File("xml/testNamespaces.xml"));
    }
}

