/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class CopyTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.CopyTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testRoot() throws Exception {
        this.document.setName("doc1");
        Element root = this.document.getRootElement();
        List authors = root.elements("author");
        CopyTest.assertTrue((String)"Should be at least 2 authors", (authors.size() == 2 ? 1 : 0) != 0);
        Element author1 = (Element)authors.get(0);
        Element author2 = (Element)authors.get(1);
        this.testCopy(root);
        this.testCopy(author1);
        this.testCopy(author2);
    }

    protected void testCopy(Element element) throws Exception {
        CopyTest.assertTrue((String)"Not null", (element != null ? 1 : 0) != 0);
        int attributeCount = element.attributeCount();
        int nodeCount = element.nodeCount();
        Element copy = element.createCopy();
        CopyTest.assertEquals((String)"Node size not equal after copy", (int)element.nodeCount(), (int)nodeCount);
        CopyTest.assertTrue((String)"Same attribute size after copy", (element.attributeCount() == attributeCount ? 1 : 0) != 0);
        CopyTest.assertTrue((String)"Copy has same node size", (copy.nodeCount() == nodeCount ? 1 : 0) != 0);
        CopyTest.assertTrue((String)"Copy has same attribute size", (copy.attributeCount() == attributeCount ? 1 : 0) != 0);
        int i = 0;
        while (i < attributeCount) {
            Attribute attr1 = element.attribute(i);
            Attribute attr2 = copy.attribute(i);
            CopyTest.assertTrue((String)("Attribute: " + i + " name is equal"), (boolean)attr1.getName().equals(attr2.getName()));
            CopyTest.assertTrue((String)("Attribute: " + i + " value is equal"), (boolean)attr1.getValue().equals(attr2.getValue()));
            ++i;
        }
        i = 0;
        while (i < nodeCount) {
            Node node1 = element.node(i);
            Node node2 = copy.node(i);
            CopyTest.assertTrue((String)("Node: " + i + " type is equal"), (node1.getNodeType() == node2.getNodeType() ? 1 : 0) != 0);
            CopyTest.assertTrue((String)("Node: " + i + " value is equal"), (boolean)node1.getText().equals(node2.getText()));
            ++i;
        }
    }
}

