/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import java.math.BigInteger;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeAttribute;
import org.dom4j.datatype.DatatypeDocumentFactory;

public class SetDataTest
extends AbstractTestCase {
    private DatatypeDocumentFactory factory = new DatatypeDocumentFactory();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.datatype.SetDataTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testAttribute() throws Exception {
        QName personName = this.factory.createQName("person");
        QName ageName = this.factory.createQName("age");
        Element person = this.factory.createElement(personName);
        person.addAttribute(ageName, "10");
        Attribute age = person.attribute(ageName);
        SetDataTest.assertTrue((String)"Created DatatypeAttribute not correct", (boolean)(age instanceof DatatypeAttribute));
        this.log("Found attribute: " + age);
        Object data = age.getData();
        BigInteger expected = new BigInteger("10");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SetDataTest.assertEquals((String)"Data is correct type", (Object)clazz, data.getClass());
        SetDataTest.assertEquals((String)"Set age correctly", (Object)expected, (Object)data);
        age.setValue("32");
        data = age.getData();
        expected = new BigInteger("32");
        SetDataTest.assertEquals((String)"Set age correctly", (Object)expected, (Object)data);
        try {
            age.setValue("abc");
            SetDataTest.fail((String)"Appeared to set an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAttributeWithNamespace() throws Exception {
        QName personName = this.factory.createQName("person", "t", "urn://testing");
        QName ageName = this.factory.createQName("age", "t", "urn://testing");
        Element person = this.factory.createElement(personName);
        person.addAttribute(ageName, "10");
        Attribute age = person.attribute(ageName);
        SetDataTest.assertTrue((String)"Created DatatypeAttribute not correct", (boolean)(age instanceof DatatypeAttribute));
        this.log("Found attribute: " + age);
        Object data = age.getData();
        BigInteger expected = new BigInteger("10");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SetDataTest.assertEquals((String)"Data is correct type", (Object)clazz, data.getClass());
        SetDataTest.assertEquals((String)"Set age correctly", (Object)expected, (Object)data);
        age.setValue("32");
        data = age.getData();
        expected = new BigInteger("32");
        SetDataTest.assertEquals((String)"Set age correctly", (Object)expected, (Object)data);
        try {
            age.setValue("abc");
            SetDataTest.fail((String)"Appeared to set an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testElement() throws Exception {
        QName personName = this.factory.createQName("person");
        QName numberOfCarsName = this.factory.createQName("numberOfCars");
        Element person = this.factory.createElement(personName);
        Element cars = person.addElement(numberOfCarsName);
        this.log("Found element: " + cars);
        Short expected = new Short(10);
        cars.setData(expected);
        Object data = cars.getData();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SetDataTest.assertEquals((String)"Data is correct type", (Object)clazz, data.getClass());
        SetDataTest.assertEquals((String)"Set cars correctly", (Object)expected, (Object)data);
        cars.setData(new Short(32));
        data = cars.getData();
        expected = new Short(32);
        SetDataTest.assertEquals((String)"Set cars correctly", (Object)expected, (Object)data);
        cars.setText("34");
        data = cars.getData();
        expected = new Short(34);
        SetDataTest.assertEquals((String)"Set cars correctly", (Object)expected, (Object)data);
        try {
            cars.setText("abc");
            SetDataTest.fail((String)"Appeared to set an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        Document schema = this.getDocument("/xml/test/schema/personal.xsd");
        this.factory.loadSchema(schema);
        Namespace ns = new Namespace("t", "urn://testing");
        this.factory.loadSchema(schema, ns);
    }
}

