/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dtd;

import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.dtd.ExternalEntityDecl;

public class ExternalEntityDeclTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.dtd.ExternalEntityDeclTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testToString() {
        ExternalEntityDecl decl1 = new ExternalEntityDecl("name", null, "systemID");
        ExternalEntityDecl decl2 = new ExternalEntityDecl("%name", null, "systemID");
        ExternalEntityDeclTest.assertEquals((String)"<!ENTITY name SYSTEM \"systemID\" >", (String)decl1.toString());
        ExternalEntityDeclTest.assertEquals((String)"<!ENTITY % name SYSTEM \"systemID\" >", (String)decl2.toString());
    }

    public void testSystemId() {
        String expectedName = "anEntity";
        String expectedPublicID = null;
        String expectedSystemID = "http://www.myorg.org/foo";
        String expectedText = "<!ENTITY anEntity SYSTEM \"http://www.myorg.org/foo\" >";
        ExternalEntityDecl actual = new ExternalEntityDecl(expectedName, expectedPublicID, expectedSystemID);
        ExternalEntityDeclTest.assertEquals((String)"name is correct", (String)expectedName, (String)actual.getName());
        ExternalEntityDeclTest.assertEquals((String)"publicID is correct", expectedPublicID, (String)actual.getPublicID());
        ExternalEntityDeclTest.assertEquals((String)"systemID is correct", (String)expectedSystemID, (String)actual.getSystemID());
        ExternalEntityDeclTest.assertEquals((String)"toString() is correct", (String)expectedText, (String)actual.toString());
    }

    public void testPublicIdSystemId() {
        String expectedName = "anEntity";
        String expectedPublicID = "-//dom4j//DTD sample";
        String expectedSystemID = "http://www.myorg.org/foo";
        String expectedText = "<!ENTITY anEntity PUBLIC \"-//dom4j//DTD sample\" \"http://www.myorg.org/foo\" >";
        ExternalEntityDecl actual = new ExternalEntityDecl(expectedName, expectedPublicID, expectedSystemID);
        ExternalEntityDeclTest.assertEquals((String)"name is correct", (String)expectedName, (String)actual.getName());
        ExternalEntityDeclTest.assertEquals((String)"publicID is correct", (String)expectedPublicID, (String)actual.getPublicID());
        ExternalEntityDeclTest.assertEquals((String)"systemID is correct", (String)expectedSystemID, (String)actual.getSystemID());
        ExternalEntityDeclTest.assertEquals((String)"toString() is correct", (String)expectedText, (String)actual.toString());
    }
}

