/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class SAXReaderTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.io.SAXReaderTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testReadFile() throws Exception {
        File file = this.getFile("/xml/#.xml");
        new SAXReader().read(file);
    }

    public void testEncoding() throws Exception {
        String xml = "<?xml version='1.0' encoding='ISO-8859-1'?><root/>";
        SAXReader reader = new SAXReader();
        reader.setEncoding("ISO-8859-1");
        Document doc = reader.read(new StringReader(xml));
        SAXReaderTest.assertEquals((String)"encoding incorrect", (String)"ISO-8859-1", (String)doc.getXMLEncoding());
    }

    public void testRussian() throws Exception {
        Document doc = this.getDocument("/xml/russArticle.xml");
        SAXReaderTest.assertEquals((String)"encoding not correct", (String)"koi8-r", (String)doc.getXMLEncoding());
        Element el = doc.getRootElement();
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(writer);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("koi8-r");
        xmlWriter.write(doc);
        this.log(writer.toString());
    }

    public void testRussian2() throws Exception {
        Document doc = this.getDocument("/xml/russArticle.xml");
        XMLWriter xmlWriter = new XMLWriter(new OutputFormat("", false, "koi8-r"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        xmlWriter.setOutputStream(out);
        xmlWriter.write(doc);
        xmlWriter.flush();
        xmlWriter.close();
        this.log(out.toString());
    }

    public void testBug833765() throws Exception {
        SAXReader reader = new SAXReader();
        reader.setIncludeExternalDTDDeclarations(true);
        this.getDocument("/xml/dtd/external.xml", reader);
    }

    public void testBug527062() throws Exception {
        Document doc = this.getDocument("/xml/test/test.xml");
        List l = doc.selectNodes("//broked/junk");
        int i = 0;
        while (i < l.size()) {
            System.out.println("Found node: " + ((Element)l.get(i)).getStringValue());
            ++i;
        }
        SAXReaderTest.assertEquals((String)"hi there", (String)((Element)l.get(0)).getStringValue());
        SAXReaderTest.assertEquals((String)"hello world", (String)((Element)l.get(1)).getStringValue());
    }

    public void testEscapedComment() throws Exception {
        String txt = "<eg>&lt;!-- &lt;head> &amp; &lt;body> --&gt;</eg>";
        Document doc = DocumentHelper.parseText(txt);
        Element eg = doc.getRootElement();
        System.out.println(doc.asXML());
        SAXReaderTest.assertEquals((String)"<!-- <head> & <body> -->", (String)eg.getText());
    }
}

