/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.ArrayList;
import java.util.Collections;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.rule.Pattern;
import org.dom4j.rule.Rule;

public class RuleTest
extends AbstractTestCase {
    protected DocumentFactory factory = new DocumentFactory();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.rule.RuleTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testOrder() throws Exception {
        this.testGreater("foo", "*");
    }

    protected void testGreater(String expr1, String expr2) throws Exception {
        System.out.println("parsing: " + expr1 + " and " + expr2);
        Rule r1 = this.createRule(expr1);
        Rule r2 = this.createRule(expr2);
        System.out.println("rule1: " + r1 + " rule2: " + r2);
        int value = r1.compareTo(r2);
        System.out.println("Comparison: " + value);
        RuleTest.assertTrue((String)"r1 > r2", (value > 0 ? 1 : 0) != 0);
        ArrayList<Rule> list = new ArrayList<Rule>();
        list.add(r1);
        list.add(r2);
        Collections.sort(list);
        RuleTest.assertTrue((String)"r2 should be first", (list.get(0) == r2 ? 1 : 0) != 0);
        RuleTest.assertTrue((String)"r1 should be next", (list.get(1) == r1 ? 1 : 0) != 0);
        list = new ArrayList();
        list.add(r2);
        list.add(r1);
        Collections.sort(list);
        RuleTest.assertTrue((String)"r2 should be first", (list.get(0) == r2 ? 1 : 0) != 0);
        RuleTest.assertTrue((String)"r1 should be next", (list.get(1) == r1 ? 1 : 0) != 0);
    }

    public void testDocument() {
        Rule rule = this.createRule("/");
        Document document = this.factory.createDocument();
        document.addElement("foo");
        RuleTest.assertTrue((String)"/ matches document", (boolean)rule.matches(document));
        RuleTest.assertTrue((String)"/ does not match root element", (!rule.matches(document.getRootElement()) ? 1 : 0) != 0);
    }

    public void testTextMatchesCDATA() {
        CDATA cdata = this.factory.createCDATA("<>&");
        Rule rule = this.createRule("text()");
        RuleTest.assertTrue((String)"text() matches CDATA", (boolean)rule.matches(cdata));
    }

    protected Rule createRule(String expr) {
        Pattern pattern = this.factory.createPattern(expr);
        return new Rule(pattern);
    }
}

