/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import net.roseboy.classfinal.JarDecryptor;
import net.roseboy.classfinal.util.JarUtils;
import net.roseboy.classfinal.util.StrUtils;

public class AgentTransformer
implements ClassFileTransformer {
    private char[] pwd;

    public AgentTransformer(char[] pwd) {
        this.pwd = pwd;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classBuffer) {
        if (className == null || domain == null || loader == null) {
            return classBuffer;
        }
        String projectPath = domain.getCodeSource().getLocation().getPath();
        if (StrUtils.isEmpty(projectPath = JarUtils.getRootPath(projectPath))) {
            return classBuffer;
        }
        className = className.replace("/", ".").replace("\\", ".");
        byte[] bytes = JarDecryptor.getInstance().doDecrypt(projectPath, className, this.pwd);
        if (bytes != null && bytes[0] == -54 && bytes[1] == -2 && bytes[2] == -70 && bytes[3] == -66) {
            return bytes;
        }
        return classBuffer;
    }
}

