/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.IntegerType;
import java.nio.ByteBuffer;

public class ByteSerializer
extends AbstractSerializer<Byte> {
    private static final ByteSerializer instance = new ByteSerializer();

    public static ByteSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Byte obj) {
        if (obj == null) {
            return null;
        }
        ByteBuffer b = ByteBuffer.allocate(1);
        b.put(obj);
        b.rewind();
        return b;
    }

    @Override
    public Byte fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer dup = byteBuffer.duplicate();
        byte in = dup.get();
        return in;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return this.toByteBuffer(Byte.parseByte(str));
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return IntegerType.instance.getString(byteBuffer);
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        Byte val = this.fromByteBuffer(byteBuffer.duplicate());
        if (val == 127) {
            throw new ArithmeticException("Can't paginate past max byte");
        }
        Byte by = val;
        Byte by2 = val = Byte.valueOf((byte)(val + 1));
        return this.toByteBuffer(val);
    }
}

