/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.auth;

import com.google.common.base.Objects;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Auth;

public class AuthenticatedUser {
    public static final String ANONYMOUS_USERNAME = "anonymous";
    public static final AuthenticatedUser ANONYMOUS_USER = new AuthenticatedUser("anonymous");
    private final String name;

    public AuthenticatedUser(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSuper() {
        return !this.isAnonymous() && Auth.isSuperuser(this.name);
    }

    public boolean isAnonymous() {
        return this == ANONYMOUS_USER;
    }

    public String toString() {
        return String.format("#<User %s>", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticatedUser)) {
            return false;
        }
        AuthenticatedUser u = (AuthenticatedUser)o;
        return Objects.equal((Object)this.name, (Object)u.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }
}

