/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.KSMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.KSPropDefs;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.AbstractReplicationStrategy;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.MigrationManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;

public class AlterKeyspaceStatement
extends SchemaAlteringStatement {
    private final String name;
    private final KSPropDefs attrs;

    public AlterKeyspaceStatement(String name, KSPropDefs attrs) {
        this.name = name;
        this.attrs = attrs;
    }

    @Override
    public String keyspace() {
        return this.name;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.name, Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        KSMetaData ksm = Schema.instance.getKSMetaData(this.name);
        if (ksm == null) {
            throw new InvalidRequestException("Unknown keyspace " + this.name);
        }
        if (ksm.name.equalsIgnoreCase("system")) {
            throw new InvalidRequestException("Cannot alter system keyspace");
        }
        this.attrs.validate();
        if (this.attrs.getReplicationStrategyClass() == null && !this.attrs.getReplicationOptions().isEmpty()) {
            throw new ConfigurationException("Missing replication strategy class");
        }
        if (this.attrs.getReplicationStrategyClass() != null) {
            AbstractReplicationStrategy.validateReplicationStrategy(this.name, AbstractReplicationStrategy.getClass(this.attrs.getReplicationStrategyClass()), StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), this.attrs.getReplicationOptions());
        }
    }

    @Override
    public boolean announceMigration() throws RequestValidationException {
        KSMetaData ksm = Schema.instance.getKSMetaData(this.name);
        if (ksm == null) {
            throw new InvalidRequestException("Unknown keyspace " + this.name);
        }
        MigrationManager.announceKeyspaceUpdate(this.attrs.asKSMetadataUpdate(ksm));
        return true;
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }
}

