/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterColumn;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterUpdateColumn;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletedColumn;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ExpiringColumn;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.FSReadError;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.ISerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileDataInput;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ColumnSerializer
implements ISerializer<Column> {
    public static final int DELETION_MASK = 1;
    public static final int EXPIRATION_MASK = 2;
    public static final int COUNTER_MASK = 4;
    public static final int COUNTER_UPDATE_MASK = 8;
    public static final int RANGE_TOMBSTONE_MASK = 16;

    @Override
    public void serialize(Column column, DataOutput out) throws IOException {
        assert (column.name().remaining() > 0);
        ByteBufferUtil.writeWithShortLength(column.name(), out);
        try {
            out.writeByte(column.serializationFlags());
            if (column instanceof CounterColumn) {
                out.writeLong(((CounterColumn)column).timestampOfLastDelete());
            } else if (column instanceof ExpiringColumn) {
                out.writeInt(((ExpiringColumn)column).getTimeToLive());
                out.writeInt(column.getLocalDeletionTime());
            }
            out.writeLong(column.timestamp());
            ByteBufferUtil.writeWithLength(column.value(), out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Column deserialize(DataInput in) throws IOException {
        return this.deserialize(in, Flag.LOCAL);
    }

    public Column deserialize(DataInput in, Flag flag) throws IOException {
        return this.deserialize(in, flag, Integer.MIN_VALUE);
    }

    public Column deserialize(DataInput in, Flag flag, int expireBefore) throws IOException {
        ByteBuffer name = ByteBufferUtil.readWithShortLength(in);
        if (name.remaining() <= 0) {
            throw CorruptColumnException.create(in, name);
        }
        int b = in.readUnsignedByte();
        return this.deserializeColumnBody(in, name, b, flag, expireBefore);
    }

    Column deserializeColumnBody(DataInput in, ByteBuffer name, int mask, Flag flag, int expireBefore) throws IOException {
        if ((mask & 4) != 0) {
            long timestampOfLastDelete = in.readLong();
            long ts = in.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(in);
            return CounterColumn.create(name, value, ts, timestampOfLastDelete, flag);
        }
        if ((mask & 2) != 0) {
            int ttl = in.readInt();
            int expiration = in.readInt();
            long ts = in.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(in);
            return ExpiringColumn.create(name, value, ts, ttl, expiration, expireBefore, flag);
        }
        long ts = in.readLong();
        ByteBuffer value = ByteBufferUtil.readWithLength(in);
        return (mask & 8) != 0 ? new CounterUpdateColumn(name, value, ts) : ((mask & 1) == 0 ? new Column(name, value, ts) : new DeletedColumn(name, value, ts));
    }

    @Override
    public long serializedSize(Column column, TypeSizes type) {
        return column.serializedSize(type);
    }

    public static class CorruptColumnException
    extends IOException {
        public CorruptColumnException(String s) {
            super(s);
        }

        public static CorruptColumnException create(DataInput in, ByteBuffer name) {
            assert (name.remaining() <= 0);
            String format = "invalid column name length %d%s";
            String details = "";
            if (in instanceof FileDataInput) {
                long remaining;
                FileDataInput fdis = (FileDataInput)in;
                try {
                    remaining = fdis.bytesRemaining();
                }
                catch (IOException e) {
                    throw new FSReadError((Throwable)e, fdis.getPath());
                }
                details = String.format(" (%s, %d bytes remaining)", fdis.getPath(), remaining);
            }
            return new CorruptColumnException(String.format(format, name.remaining(), details));
        }
    }

    public static enum Flag {
        LOCAL,
        FROM_REMOTE,
        PRESERVE_SIZE;

    }
}

