/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.dht;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SystemKeyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.FailureDetector;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.IFailureDetector;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.AbstractReplicationStrategy;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.IEndpointSnitch;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.TokenMetadata;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamPlan;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamResultFuture;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeStreamer {
    private static final Logger logger = LoggerFactory.getLogger(RangeStreamer.class);
    private final TokenMetadata metadata;
    private final InetAddress address;
    private final String description;
    private final Multimap<String, Map.Entry<InetAddress, Collection<Range<Token>>>> toFetch = HashMultimap.create();
    private final Set<ISourceFilter> sourceFilters = new HashSet<ISourceFilter>();
    private final StreamPlan streamPlan;

    public RangeStreamer(TokenMetadata metadata, InetAddress address, String description) {
        this.metadata = metadata;
        this.address = address;
        this.description = description;
        this.streamPlan = new StreamPlan(description);
    }

    public void addSourceFilter(ISourceFilter filter) {
        this.sourceFilters.add(filter);
    }

    public void addRanges(String keyspaceName, Collection<Range<Token>> ranges) {
        Multimap<Range<Token>, InetAddress> rangesForKeyspace = this.getAllRangesWithSourcesFor(keyspaceName, ranges);
        if (logger.isDebugEnabled()) {
            for (Map.Entry entry : rangesForKeyspace.entries()) {
                logger.debug(String.format("%s: range %s exists on %s", this.description, entry.getKey(), entry.getValue()));
            }
        }
        for (Map.Entry entry : RangeStreamer.getRangeFetchMap(rangesForKeyspace, this.sourceFilters, keyspaceName).asMap().entrySet()) {
            if (logger.isDebugEnabled()) {
                for (Range r : (Collection)entry.getValue()) {
                    logger.debug(String.format("%s: range %s from source %s for keyspace %s", this.description, r, entry.getKey(), keyspaceName));
                }
            }
            this.toFetch.put((Object)keyspaceName, (Object)entry);
        }
    }

    private Multimap<Range<Token>, InetAddress> getAllRangesWithSourcesFor(String keyspaceName, Collection<Range<Token>> desiredRanges) {
        AbstractReplicationStrategy strat = Keyspace.open(keyspaceName).getReplicationStrategy();
        Multimap<Range<Token>, InetAddress> rangeAddresses = strat.getRangeAddresses(this.metadata.cloneOnlyTokenMap());
        ArrayListMultimap rangeSources = ArrayListMultimap.create();
        for (Range<Token> desiredRange : desiredRanges) {
            for (Range range : rangeAddresses.keySet()) {
                if (!range.contains(desiredRange)) continue;
                List<InetAddress> preferred = DatabaseDescriptor.getEndpointSnitch().getSortedListByProximity(this.address, rangeAddresses.get((Object)range));
                rangeSources.putAll(desiredRange, preferred);
                break;
            }
            if (rangeSources.keySet().contains(desiredRange)) continue;
            throw new IllegalStateException("No sources found for " + desiredRange);
        }
        return rangeSources;
    }

    private static Multimap<InetAddress, Range<Token>> getRangeFetchMap(Multimap<Range<Token>, InetAddress> rangesWithSources, Collection<ISourceFilter> sourceFilters, String keyspace) {
        HashMultimap rangeFetchMapMap = HashMultimap.create();
        for (Range range : rangesWithSources.keySet()) {
            boolean foundSource = false;
            block1: for (InetAddress address : rangesWithSources.get((Object)range)) {
                if (address.equals(FBUtilities.getBroadcastAddress())) {
                    foundSource = true;
                    continue;
                }
                for (ISourceFilter filter : sourceFilters) {
                    if (filter.shouldInclude(address)) continue;
                    continue block1;
                }
                rangeFetchMapMap.put((Object)address, (Object)range);
                foundSource = true;
                break;
            }
            if (foundSource) continue;
            throw new IllegalStateException("unable to find sufficient sources for streaming range " + range + " in keyspace " + keyspace);
        }
        return rangeFetchMapMap;
    }

    public static Multimap<InetAddress, Range<Token>> getWorkMap(Multimap<Range<Token>, InetAddress> rangesWithSourceTarget, String keyspace) {
        return RangeStreamer.getRangeFetchMap(rangesWithSourceTarget, Collections.singleton(new FailureDetectorSourceFilter(FailureDetector.instance)), keyspace);
    }

    Multimap<String, Map.Entry<InetAddress, Collection<Range<Token>>>> toFetch() {
        return this.toFetch;
    }

    public StreamResultFuture fetchAsync() {
        for (Map.Entry entry : this.toFetch.entries()) {
            String keyspace = (String)entry.getKey();
            InetAddress source = (InetAddress)((Map.Entry)entry.getValue()).getKey();
            InetAddress preferred = SystemKeyspace.getPreferredIP(source);
            Collection ranges = (Collection)((Map.Entry)entry.getValue()).getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("" + this.description + "ing from " + source + " ranges " + StringUtils.join((Iterable)ranges, (String)", "));
            }
            this.streamPlan.requestRanges(source, preferred, keyspace, ranges);
        }
        return this.streamPlan.execute();
    }

    public static class SingleDatacenterFilter
    implements ISourceFilter {
        private final String sourceDc;
        private final IEndpointSnitch snitch;

        public SingleDatacenterFilter(IEndpointSnitch snitch, String sourceDc) {
            this.sourceDc = sourceDc;
            this.snitch = snitch;
        }

        @Override
        public boolean shouldInclude(InetAddress endpoint) {
            return this.snitch.getDatacenter(endpoint).equals(this.sourceDc);
        }
    }

    public static class FailureDetectorSourceFilter
    implements ISourceFilter {
        private final IFailureDetector fd;

        public FailureDetectorSourceFilter(IFailureDetector fd) {
            this.fd = fd;
        }

        @Override
        public boolean shouldInclude(InetAddress endpoint) {
            return this.fd.isAlive(endpoint);
        }
    }

    public static interface ISourceFilter {
        public boolean shouldInclude(InetAddress var1);
    }
}

