/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.gms;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.EndpointState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.GossipDigest;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.GossipDigestAck;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.GossipDigestSerializationHelper;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.CompactEndpointSerializationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GossipDigestAckSerializer
implements IVersionedSerializer<GossipDigestAck> {
    GossipDigestAckSerializer() {
    }

    @Override
    public void serialize(GossipDigestAck gDigestAckMessage, DataOutput out, int version) throws IOException {
        GossipDigestSerializationHelper.serialize(gDigestAckMessage.gDigestList, out, version);
        out.writeInt(gDigestAckMessage.epStateMap.size());
        for (Map.Entry<InetAddress, EndpointState> entry : gDigestAckMessage.epStateMap.entrySet()) {
            InetAddress ep = entry.getKey();
            CompactEndpointSerializationHelper.serialize(ep, out);
            EndpointState.serializer.serialize(entry.getValue(), out, version);
        }
    }

    @Override
    public GossipDigestAck deserialize(DataInput in, int version) throws IOException {
        List<GossipDigest> gDigestList = GossipDigestSerializationHelper.deserialize(in, version);
        int size = in.readInt();
        HashMap<InetAddress, EndpointState> epStateMap = new HashMap<InetAddress, EndpointState>(size);
        for (int i = 0; i < size; ++i) {
            InetAddress ep = CompactEndpointSerializationHelper.deserialize(in);
            EndpointState epState = EndpointState.serializer.deserialize(in, version);
            epStateMap.put(ep, epState);
        }
        return new GossipDigestAck(gDigestList, epStateMap);
    }

    @Override
    public long serializedSize(GossipDigestAck ack, int version) {
        int size = GossipDigestSerializationHelper.serializedSize(ack.gDigestList, version);
        size += TypeSizes.NATIVE.sizeof(ack.epStateMap.size());
        for (Map.Entry<InetAddress, EndpointState> entry : ack.epStateMap.entrySet()) {
            size = (int)((long)size + ((long)CompactEndpointSerializationHelper.serializedSize(entry.getKey()) + EndpointState.serializer.serializedSize(entry.getValue(), version)));
        }
        return size;
    }
}

