/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.metrics;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.CompactionInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.CompactionManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.metrics.DefaultNameFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.metrics.MetricNameFactory;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CompactionMetrics
implements CompactionManager.CompactionExecutorStatsCollector {
    public static final MetricNameFactory factory = new DefaultNameFactory("Compaction");
    private static final Set<CompactionInfo.Holder> compactions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    public final Gauge<Integer> pendingTasks = Metrics.newGauge((MetricName)factory.createMetricName("PendingTasks"), (Gauge)new Gauge<Integer>(){

        public Integer value() {
            int n = 0;
            for (String keyspaceName : Schema.instance.getKeyspaces()) {
                for (ColumnFamilyStore cfs : Keyspace.open(keyspaceName).getColumnFamilyStores()) {
                    n += cfs.getCompactionStrategy().getEstimatedRemainingTasks();
                }
            }
            return n + compactions.size();
        }
    });
    public final Gauge<Long> completedTasks;
    public final Meter totalCompactionsCompleted;
    public final Counter bytesCompacted;

    public CompactionMetrics(final ThreadPoolExecutor ... collectors) {
        this.completedTasks = Metrics.newGauge((MetricName)factory.createMetricName("CompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long completedTasks = 0L;
                for (ThreadPoolExecutor collector : collectors) {
                    completedTasks += collector.getCompletedTaskCount();
                }
                return completedTasks;
            }
        });
        this.totalCompactionsCompleted = Metrics.newMeter((MetricName)factory.createMetricName("TotalCompactionsCompleted"), (String)"compaction completed", (TimeUnit)TimeUnit.SECONDS);
        this.bytesCompacted = Metrics.newCounter((MetricName)factory.createMetricName("BytesCompacted"));
    }

    @Override
    public void beginCompaction(CompactionInfo.Holder ci) {
        ci.started();
        compactions.add(ci);
    }

    @Override
    public void finishCompaction(CompactionInfo.Holder ci) {
        ci.finished();
        compactions.remove(ci);
        this.bytesCompacted.inc(ci.getCompactionInfo().getTotal());
        this.totalCompactionsCompleted.mark();
    }

    public static List<CompactionInfo.Holder> getCompactions() {
        return new ArrayList<CompactionInfo.Holder>(compactions);
    }
}

