/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils;

import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Hex;
import java.util.Arrays;

public class MD5Digest {
    public final byte[] bytes;

    private MD5Digest(byte[] bytes) {
        this.bytes = bytes;
    }

    public static MD5Digest wrap(byte[] digest) {
        return new MD5Digest(digest);
    }

    public static MD5Digest compute(byte[] toHash) {
        return new MD5Digest(FBUtilities.threadLocalMD5Digest().digest(toHash));
    }

    public static MD5Digest compute(String toHash) {
        return MD5Digest.compute(toHash.getBytes());
    }

    public final int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof MD5Digest)) {
            return false;
        }
        MD5Digest that = (MD5Digest)o;
        return FBUtilities.compareUnsigned(this.bytes, that.bytes, 0, 0, this.bytes.length, that.bytes.length) == 0;
    }

    public String toString() {
        return Hex.bytesToHex(this.bytes);
    }
}

