/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.impexp;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasImportResult {
    private static final long serialVersionUID = 1L;
    private AtlasImportRequest request;
    private String userName;
    private String clientIpAddress;
    private String hostName;
    private long timeStamp;
    private Map<String, Integer> metrics;
    private List<String> processedEntities;
    private OperationStatus operationStatus;
    private AtlasExportResult exportResultWithoutData;

    public AtlasImportResult() {
        this(null, null, null, null, System.currentTimeMillis());
    }

    public AtlasImportResult(AtlasImportRequest request, String userName, String clientIpAddress, String hostName, long timeStamp) {
        this.request = request;
        this.userName = userName;
        this.clientIpAddress = clientIpAddress;
        this.hostName = hostName;
        this.timeStamp = timeStamp;
        this.metrics = new HashMap<String, Integer>();
        this.operationStatus = OperationStatus.FAIL;
        this.processedEntities = new ArrayList<String>();
    }

    public AtlasImportRequest getRequest() {
        return this.request;
    }

    public void setRequest(AtlasImportRequest request) {
        this.request = request;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Map<String, Integer> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Integer> metrics) {
        this.metrics = metrics;
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public void setOperationStatus(OperationStatus operationStatus) {
        this.operationStatus = operationStatus;
    }

    public void incrementMeticsCounter(String key) {
        this.incrementMeticsCounter(key, 1);
    }

    public void incrementMeticsCounter(String key, int incrementBy) {
        int currentValue = this.metrics.containsKey(key) ? this.metrics.get(key) : 0;
        this.metrics.put(key, currentValue + incrementBy);
    }

    public void setProcessedEntities(List<String> processedEntities) {
        this.processedEntities = processedEntities;
    }

    public List<String> getProcessedEntities() {
        return this.processedEntities;
    }

    public AtlasExportResult getExportResult() {
        return this.exportResultWithoutData;
    }

    public void setExportResult(AtlasExportResult exportResult) {
        this.exportResultWithoutData = exportResult;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasImportResult{");
        sb.append("request={").append(this.request).append("}");
        sb.append(", userName='").append(this.userName).append("'");
        sb.append(", clientIpAddress='").append(this.clientIpAddress).append("'");
        sb.append(", hostName='").append(this.hostName).append("'");
        sb.append(", timeStamp='").append(this.timeStamp).append("'");
        sb.append(", metrics={");
        AtlasBaseTypeDef.dumpObjects(this.metrics, sb);
        sb.append("}");
        sb.append(", operationStatus='").append((Object)this.operationStatus).append("'");
        sb.append(", processedEntities=[");
        AtlasBaseTypeDef.dumpObjects(this.processedEntities, sb);
        sb.append("]");
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static enum OperationStatus {
        SUCCESS,
        PARTIAL_SUCCESS,
        FAIL;

    }
}

