/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.entitytransform.TransformerContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Action {
    private static final Logger LOG = LoggerFactory.getLogger(Action.class);
    private static final String ACTION_DELIMITER = ":";
    private static final String ACTION_ADD_CLASSIFICATION = "ADD_CLASSIFICATION";
    private static final String ACTION_NAME_SET = "SET";
    private static final String ACTION_NAME_REPLACE_PREFIX = "REPLACE_PREFIX";
    private static final String ACTION_NAME_TO_LOWER = "TO_LOWER";
    private static final String ACTION_NAME_TO_UPPER = "TO_UPPER";
    private static final String ACTION_NAME_CLEAR = "CLEAR";
    protected final EntityAttribute attribute;

    protected Action(EntityAttribute attribute) {
        this.attribute = attribute;
    }

    public EntityAttribute getAttribute() {
        return this.attribute;
    }

    public boolean isValid() {
        return true;
    }

    public abstract void apply(BaseEntityHandler.AtlasTransformableEntity var1);

    public static Action createAction(String key, String value, TransformerContext context) {
        Action ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> Action.createAction(key={}, value={})", (Object)key, (Object)value);
        }
        int idxActionDelim = value == null ? -1 : value.indexOf(ACTION_DELIMITER);
        String actionName = idxActionDelim == -1 ? ACTION_NAME_SET : value.substring(0, idxActionDelim);
        String actionValue = idxActionDelim == -1 ? value : value.substring(idxActionDelim + ACTION_DELIMITER.length());
        actionName = StringUtils.trim((String)actionName);
        actionValue = StringUtils.trim((String)actionValue);
        value = StringUtils.trim((String)value);
        EntityAttribute attribute = new EntityAttribute(StringUtils.trim((String)key), context);
        switch (actionName.toUpperCase()) {
            case "ADD_CLASSIFICATION": {
                ret = new AddClassificationAction(attribute, actionValue, context);
                break;
            }
            case "REPLACE_PREFIX": {
                ret = new PrefixReplaceAction(attribute, actionValue);
                break;
            }
            case "TO_LOWER": {
                ret = new ToLowerCaseAction(attribute);
                break;
            }
            case "TO_UPPER": {
                ret = new ToUpperCaseAction(attribute);
                break;
            }
            case "SET": {
                ret = new SetAction(attribute, actionValue);
                break;
            }
            case "CLEAR": {
                ret = new ClearAction(attribute);
                break;
            }
            default: {
                ret = new SetAction(attribute, value);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== Action.createAction(key={}, value={}): actionName={}, actionValue={}, ret={}", new Object[]{key, value, actionName, actionValue, ret});
        }
        return ret;
    }

    public static class ClearAction
    extends Action {
        public ClearAction(EntityAttribute attribute) {
            super(attribute);
        }

        @Override
        public void apply(BaseEntityHandler.AtlasTransformableEntity entity) {
            if (this.isValid() && entity.hasAttribute(this.attribute)) {
                entity.setAttribute(this.attribute, null);
            }
        }
    }

    public static class ToUpperCaseAction
    extends Action {
        public ToUpperCaseAction(EntityAttribute attribute) {
            super(attribute);
        }

        @Override
        public void apply(BaseEntityHandler.AtlasTransformableEntity entity) {
            if (this.isValid()) {
                String strValue;
                Object currValue = entity.getAttribute(this.attribute);
                String string = strValue = currValue instanceof String ? (String)currValue : null;
                if (strValue != null) {
                    entity.setAttribute(this.attribute, strValue.toUpperCase());
                }
            }
        }
    }

    public static class ToLowerCaseAction
    extends Action {
        public ToLowerCaseAction(EntityAttribute attribute) {
            super(attribute);
        }

        @Override
        public void apply(BaseEntityHandler.AtlasTransformableEntity entity) {
            if (this.isValid()) {
                String strValue;
                Object currValue = entity.getAttribute(this.attribute);
                String string = strValue = currValue instanceof String ? (String)currValue : null;
                if (strValue != null) {
                    entity.setAttribute(this.attribute, strValue.toLowerCase());
                }
            }
        }
    }

    public static class PrefixReplaceAction
    extends Action {
        private final String fromPrefix;
        private final String toPrefix;

        public PrefixReplaceAction(EntityAttribute attribute, String actionValue) {
            super(attribute);
            if (actionValue != null) {
                int idxSepDelimiter = actionValue.indexOf(Action.ACTION_DELIMITER);
                if (idxSepDelimiter == -1) {
                    this.fromPrefix = actionValue;
                    this.toPrefix = "";
                } else {
                    String prefixSep = StringUtils.trim((String)actionValue.substring(0, idxSepDelimiter));
                    int idxPrefixSep = actionValue.indexOf(prefixSep, idxSepDelimiter + Action.ACTION_DELIMITER.length());
                    if (idxPrefixSep == -1) {
                        this.fromPrefix = actionValue.substring(idxSepDelimiter + Action.ACTION_DELIMITER.length());
                        this.toPrefix = "";
                    } else {
                        this.fromPrefix = actionValue.substring(idxSepDelimiter + Action.ACTION_DELIMITER.length(), idxPrefixSep);
                        this.toPrefix = actionValue.substring(idxPrefixSep + prefixSep.length());
                    }
                }
            } else {
                this.fromPrefix = null;
                this.toPrefix = "";
            }
        }

        @Override
        public boolean isValid() {
            return super.isValid() && StringUtils.isNotEmpty((String)this.fromPrefix);
        }

        @Override
        public void apply(BaseEntityHandler.AtlasTransformableEntity entity) {
            if (this.isValid()) {
                String strValue;
                Object currValue = entity.getAttribute(this.attribute);
                String string = strValue = currValue != null ? currValue.toString() : null;
                if (strValue != null && strValue.startsWith(this.fromPrefix)) {
                    entity.setAttribute(this.attribute, StringUtils.replace((String)strValue, (String)this.fromPrefix, (String)this.toPrefix, (int)1));
                }
            }
        }
    }

    public static class AddClassificationAction
    extends Action {
        private final String classificationName;

        public AddClassificationAction(EntityAttribute attribute, String classificationName, TransformerContext context) {
            super(attribute);
            this.classificationName = classificationName;
            this.createClassificationDefIfNotExists(classificationName, context);
        }

        @Override
        public void apply(BaseEntityHandler.AtlasTransformableEntity transformableEntity) {
            AtlasClassification c;
            AtlasEntity entity = transformableEntity.getEntity();
            if (entity.getClassifications() == null) {
                entity.setClassifications(new ArrayList());
            }
            boolean hasClassification = false;
            Iterator iterator = entity.getClassifications().iterator();
            while (iterator.hasNext() && !(hasClassification = (c = (AtlasClassification)iterator.next()).getTypeName().equals(this.classificationName))) {
            }
            if (!hasClassification) {
                entity.getClassifications().add(new AtlasClassification(this.classificationName));
            }
        }

        private void createClassificationDefIfNotExists(String classificationName, TransformerContext context) {
            AtlasTypeRegistry typeRegistry;
            AtlasTypeRegistry atlasTypeRegistry = typeRegistry = context != null ? context.getTypeRegistry() : null;
            if (typeRegistry != null) {
                try {
                    AtlasClassificationDef classificationDef = typeRegistry.getClassificationDefByName(classificationName);
                    if (classificationDef == null) {
                        AtlasTypeDefStore typeDefStore = context.getTypeDefStore();
                        if (typeDefStore != null) {
                            classificationDef = new AtlasClassificationDef(classificationName);
                            AtlasTypesDef typesDef = new AtlasTypesDef();
                            typesDef.setClassificationDefs(Collections.singletonList(classificationDef));
                            typeDefStore.createTypesDef(typesDef);
                            LOG.info("created classification: {}", (Object)classificationName);
                        } else {
                            LOG.warn("skipped creation of classification {}. typeDefStore is null", (Object)classificationName);
                        }
                    }
                }
                catch (AtlasBaseException e) {
                    LOG.error("Error creating classification: {}", (Object)classificationName, (Object)e);
                }
            }
        }
    }

    public static class SetAction
    extends Action {
        private final String attributeValue;

        public SetAction(EntityAttribute attribute, String attributeValue) {
            super(attribute);
            this.attributeValue = attributeValue;
        }

        @Override
        public void apply(BaseEntityHandler.AtlasTransformableEntity entity) {
            entity.setAttribute(this.attribute, this.attributeValue);
        }
    }
}

