/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.query.GremlinQueryComposer;
import org.apache.atlas.query.IdentifierHelper;
import org.apache.atlas.query.Lookup;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;

class RegistryBasedLookup
implements Lookup {
    private static final Map<String, String> NUMERIC_ATTRIBUTES = new HashMap<String, String>(){
        {
            this.put("byte", "");
            this.put("short", "");
            this.put("int", "");
            this.put("long", "L");
            this.put("float", "f");
            this.put("double", "d");
            this.put("biginteger", "");
            this.put("bigdecimal", "");
        }
    };
    private final AtlasTypeRegistry typeRegistry;

    public RegistryBasedLookup(AtlasTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public AtlasType getType(String typeName) throws AtlasBaseException {
        Object ret = typeName.equals("_CLASSIFIED") ? SearchContext.MATCH_ALL_CLASSIFIED : (typeName.equals("_NOT_CLASSIFIED") ? SearchContext.MATCH_ALL_NOT_CLASSIFIED : (typeName.equals("_ALL_ENTITY_TYPES") ? SearchContext.MATCH_ALL_ENTITY_TYPES : this.typeRegistry.getType(typeName)));
        return ret;
    }

    @Override
    public String getQualifiedName(GremlinQueryComposer.Context context, String name) throws AtlasBaseException {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null && this.isClassificationType(context)) {
            et = (AtlasClassificationType)context.getActiveType();
        }
        if (et == null) {
            return "";
        }
        return et.getVertexPropertyName(name);
    }

    @Override
    public boolean isPrimitive(GremlinQueryComposer.Context context, String attributeName) {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null && this.isClassificationType(context)) {
            et = (AtlasClassificationType)context.getActiveType();
        }
        if (et == null) {
            return false;
        }
        AtlasType at = this.getAttributeType((AtlasStructType)et, attributeName);
        if (at == null) {
            return false;
        }
        TypeCategory tc = at.getTypeCategory();
        if (this.isPrimitiveUsingTypeCategory(tc)) {
            return true;
        }
        if (tc != null && tc == TypeCategory.ARRAY) {
            AtlasArrayType ct = (AtlasArrayType)at;
            return this.isPrimitiveUsingTypeCategory(ct.getElementType().getTypeCategory());
        }
        if (tc != null && tc == TypeCategory.MAP) {
            AtlasMapType ct = (AtlasMapType)at;
            return this.isPrimitiveUsingTypeCategory(ct.getValueType().getTypeCategory());
        }
        return false;
    }

    private boolean isPrimitiveUsingTypeCategory(TypeCategory tc) {
        return tc != null && (tc == TypeCategory.PRIMITIVE || tc == TypeCategory.ENUM);
    }

    @Override
    public String getRelationshipEdgeLabel(GremlinQueryComposer.Context context, String attributeName) {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return "";
        }
        AtlasStructType.AtlasAttribute attr = this.getAttribute((AtlasStructType)et, attributeName);
        return attr != null ? attr.getRelationshipEdgeLabel() : "";
    }

    @Override
    public AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection getRelationshipEdgeDirection(GremlinQueryComposer.Context context, String attributeName) {
        AtlasEntityType entityType = context.getActiveEntityType();
        AtlasStructType.AtlasAttribute attribute = null;
        AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection ret = null;
        if (entityType != null && (attribute = entityType.getRelationshipAttribute(attributeName, null)) != null) {
            ret = attribute.getRelationshipEdgeDirection();
        }
        return ret;
    }

    @Override
    public boolean hasAttribute(GremlinQueryComposer.Context context, String typeName) {
        AtlasEntityType type = context.getActiveEntityType();
        if (type == null && this.isClassificationType(context)) {
            type = (AtlasClassificationType)context.getActiveType();
        }
        return this.getAttribute((AtlasStructType)type, typeName) != null;
    }

    @Override
    public boolean doesTypeHaveSubTypes(GremlinQueryComposer.Context context) {
        return context.getActiveEntityType() != null && context.getActiveEntityType().getAllSubTypes().size() > 0;
    }

    @Override
    public String getTypeAndSubTypes(GremlinQueryComposer.Context context) {
        String[] str;
        String[] stringArray = str = context.getActiveEntityType() != null ? context.getActiveEntityType().getTypeAndAllSubTypes().toArray(new String[0]) : new String[]{};
        if (str.length == 0) {
            return null;
        }
        Object[] quoted = new String[str.length];
        for (int i = 0; i < str.length; ++i) {
            quoted[i] = IdentifierHelper.getQuoted(str[i]);
        }
        return StringUtils.join((Object[])quoted, (String)",");
    }

    @Override
    public boolean isTraitType(String typeName) {
        Object t = null;
        try {
            t = typeName.equalsIgnoreCase("_CLASSIFIED") ? SearchContext.MATCH_ALL_CLASSIFIED : (typeName.equalsIgnoreCase("_NOT_CLASSIFIED") ? SearchContext.MATCH_ALL_NOT_CLASSIFIED : (typeName.equalsIgnoreCase("_ALL_ENTITY_TYPES") ? SearchContext.MATCH_ALL_ENTITY_TYPES : this.typeRegistry.getType(typeName)));
        }
        catch (AtlasBaseException e) {
            return false;
        }
        return this.isTraitType((AtlasType)t);
    }

    private boolean isTraitType(AtlasType t) {
        return t != null && t.getTypeCategory() == TypeCategory.CLASSIFICATION;
    }

    @Override
    public String getTypeFromEdge(GremlinQueryComposer.Context context, String item) {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return "";
        }
        AtlasStructType.AtlasAttribute attr = this.getAttribute((AtlasStructType)et, item);
        if (attr == null) {
            return null;
        }
        AtlasType at = attr.getAttributeType();
        switch (at.getTypeCategory()) {
            case ARRAY: {
                AtlasArrayType arrType = (AtlasArrayType)at;
                return this.getCollectionElementType(arrType.getElementType());
            }
            case MAP: {
                AtlasMapType mapType = (AtlasMapType)at;
                return this.getCollectionElementType(mapType.getValueType());
            }
        }
        return this.getAttribute((AtlasStructType)context.getActiveEntityType(), item).getTypeName();
    }

    private String getCollectionElementType(AtlasType elemType) {
        if (elemType.getTypeCategory() == TypeCategory.OBJECT_ID_TYPE) {
            return ((AtlasBuiltInTypes.AtlasObjectIdType)elemType).getObjectType();
        }
        return elemType.getTypeName();
    }

    @Override
    public boolean isDate(GremlinQueryComposer.Context context, String attributeName) {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return false;
        }
        AtlasType attr = this.getAttributeType((AtlasStructType)et, attributeName);
        return attr != null && attr.getTypeName().equals("date");
    }

    @Override
    public boolean isNumeric(GremlinQueryComposer.Context context, String attrName) {
        boolean ret;
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return false;
        }
        AtlasType attr = this.getAttributeType((AtlasStructType)et, attrName);
        boolean bl = ret = attr != null && NUMERIC_ATTRIBUTES.containsKey(attr.getTypeName());
        if (ret) {
            context.setNumericTypeFormatter(NUMERIC_ATTRIBUTES.get(attr.getTypeName()));
        }
        return ret;
    }

    @Override
    public String getVertexPropertyName(String typeName, String attrName) {
        AtlasStructType.AtlasAttribute attribute;
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        if (entityType == null && StringUtils.equals((String)typeName, (String)"_ALL_ENTITY_TYPES")) {
            entityType = SearchContext.MATCH_ALL_ENTITY_TYPES;
        }
        if ((attribute = this.getAttribute((AtlasStructType)entityType, attrName)) == null) {
            return null;
        }
        return attribute.getVertexPropertyName();
    }

    private AtlasStructType.AtlasAttribute getAttribute(AtlasStructType type, String attrName) {
        AtlasStructType.AtlasAttribute ret = null;
        if (type == null) {
            return ret;
        }
        if (type instanceof AtlasEntityType) {
            AtlasEntityType entityType = (AtlasEntityType)type;
            ret = entityType.getAttribute(attrName);
            if (ret == null) {
                ret = entityType.getRelationshipAttribute(attrName, null);
            }
            return ret;
        }
        if (type instanceof AtlasClassificationType) {
            AtlasClassificationType classificationType = (AtlasClassificationType)type;
            return classificationType.getAttribute(attrName);
        }
        return ret;
    }

    private AtlasType getAttributeType(AtlasStructType entityType, String attrName) {
        AtlasStructType.AtlasAttribute attribute = this.getAttribute(entityType, attrName);
        return attribute != null ? attribute.getAttributeType() : null;
    }

    private boolean isClassificationType(GremlinQueryComposer.Context context) {
        return context.getActiveType() instanceof AtlasClassificationType;
    }
}

