/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasException;
import org.apache.atlas.listener.ChangedTypeDefs;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.IndexChangeListener;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphIndexClient;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasRepositoryConfiguration;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexHelper
implements IndexChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(SolrIndexHelper.class);
    public static final int DEFAULT_SEARCHWEIGHT_FOR_STRINGS = 3;
    public static final int SEARCHWEIGHT_FOR_CLASSIFICATIONS = 10;
    public static final int SEARCHWEIGHT_FOR_LABELS = 10;
    public static final int SEARCHWEIGHT_FOR_CUSTOM_ATTRS = 3;
    public static final int SEARCHWEIGHT_FOR_TYPENAME = 1;
    private static final int MIN_SEARCH_WEIGHT_FOR_SUGGESTIONS = 8;
    private final AtlasTypeRegistry typeRegistry;
    public boolean initializationCompleted = false;

    public SolrIndexHelper(AtlasTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public void onChange(ChangedTypeDefs changedTypeDefs) {
        if (!AtlasRepositoryConfiguration.isFreeTextSearchEnabled()) {
            return;
        }
        if (changedTypeDefs == null || !changedTypeDefs.hasEntityDef() && !changedTypeDefs.hasBusinessMetadataDef()) {
            LOG.info("SolrIndexHelper.onChange(): no change in entity/business-metadata types. No updates needed.");
            return;
        }
        if (this.initializationCompleted) {
            try {
                AtlasGraph graph = AtlasGraphProvider.getGraphInstance();
                AtlasGraphIndexClient graphIndexClient = graph.getGraphIndexClient();
                Map<String, Integer> indexFieldName2SearchWeightMap = this.geIndexFieldNamesWithSearchWeights();
                graphIndexClient.applySearchWeight("vertex_index", indexFieldName2SearchWeightMap);
                graphIndexClient.applySuggestionFields("vertex_index", this.getIndexFieldNamesForSuggestions(indexFieldName2SearchWeightMap));
            }
            catch (AtlasException e) {
                LOG.error("Error encountered in handling type system change notification.", (Throwable)e);
                throw new RuntimeException("Error encountered in handling type system change notification.", e);
            }
        }
    }

    @Override
    public void onInitStart() {
        LOG.info("SolrIndexHelper Initialization started.");
        this.initializationCompleted = false;
    }

    @Override
    public void onInitCompletion(ChangedTypeDefs changedTypeDefs) {
        LOG.info("SolrIndexHelper Initialization completed.");
        this.initializationCompleted = true;
        this.onChange(changedTypeDefs);
    }

    private List<String> getIndexFieldNamesForSuggestions(Map<String, Integer> indexFieldName2SearchWeightMap) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : indexFieldName2SearchWeightMap.entrySet()) {
            if (entry.getValue() < 8) continue;
            String indexFieldName = entry.getKey();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding indexFieldName {} for suggestions.", (Object)indexFieldName);
            }
            ret.add(indexFieldName);
        }
        return ret;
    }

    private Map<String, Integer> geIndexFieldNamesWithSearchWeights() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put(this.typeRegistry.getIndexFieldName(Constants.CLASSIFICATION_TEXT_KEY), 10);
        ret.put(this.typeRegistry.getIndexFieldName(Constants.LABELS_PROPERTY_KEY), 10);
        ret.put(this.typeRegistry.getIndexFieldName(Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY), 3);
        ret.put(this.typeRegistry.getIndexFieldName("__typeName"), 1);
        for (AtlasEntityType entityType : this.typeRegistry.getAllEntityTypes()) {
            if (entityType.isInternalType()) continue;
            this.processType(ret, (AtlasStructType)entityType);
        }
        for (AtlasBusinessMetadataType businessMetadataType : this.typeRegistry.getAllBusinessMetadataTypes()) {
            this.processType(ret, (AtlasStructType)businessMetadataType);
        }
        return ret;
    }

    private void processType(Map<String, Integer> indexFieldNameWithSearchWeights, AtlasStructType structType) {
        List attributes = structType.getStructDef().getAttributeDefs();
        if (CollectionUtils.isNotEmpty((Collection)attributes)) {
            for (AtlasStructDef.AtlasAttributeDef attribute : attributes) {
                this.processAttribute(indexFieldNameWithSearchWeights, structType.getAttribute(attribute.getName()));
            }
        } else {
            LOG.debug("No attributes are defined for type {}", (Object)structType.getTypeName());
        }
    }

    private void processAttribute(Map<String, Integer> indexFieldNameWithSearchWeights, AtlasStructType.AtlasAttribute attribute) {
        if (attribute != null && GraphBackedSearchIndexer.isStringAttribute(attribute) && StringUtils.isNotEmpty((String)attribute.getIndexFieldName())) {
            int searchWeight = attribute.getSearchWeight();
            if (searchWeight == -1) {
                searchWeight = 3;
            } else if (!GraphBackedSearchIndexer.isValidSearchWeight(searchWeight)) {
                LOG.warn("Invalid search weight {} for attribute {}. Will use default {}", new Object[]{searchWeight, attribute.getQualifiedName(), 3});
                searchWeight = 3;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Applying search weight {} for attribute={}: indexFieldName={}", new Object[]{searchWeight, attribute.getQualifiedName(), attribute.getIndexFieldName()});
            }
            indexFieldNameWithSearchWeights.put(attribute.getIndexFieldName(), searchWeight);
        }
    }
}

