/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm.glossary;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.repository.ogm.glossary.AbstractGlossaryDTO;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasGlossaryTermDTO
extends AbstractGlossaryDTO<AtlasGlossaryTerm> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasGlossaryTermDTO.class);

    @Inject
    protected AtlasGlossaryTermDTO(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, AtlasGlossaryTerm.class);
    }

    @Override
    public AtlasGlossaryTerm from(AtlasEntity entity) {
        Object validValuesFor;
        Object validValues;
        Object classifies;
        Object isA;
        Object translatedTerms;
        Object translationTerms;
        Object replacedBy;
        Object replacementTerms;
        Object preferredToTerms;
        Object preferredTerms;
        Object antonyms;
        Object synonyms;
        Object seeAlso;
        Object assignedEntities;
        Object categories;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryTermDTO.from()", (Object)entity);
        }
        Objects.requireNonNull(entity, "entity");
        AtlasGlossaryTerm ret = new AtlasGlossaryTerm();
        ret.setGuid(entity.getGuid());
        ret.setQualifiedName((String)entity.getAttribute("qualifiedName"));
        ret.setName((String)entity.getAttribute("name"));
        ret.setShortDescription((String)entity.getAttribute("shortDescription"));
        ret.setLongDescription((String)entity.getAttribute("longDescription"));
        ret.setExamples((List)entity.getAttribute("examples"));
        ret.setAbbreviation((String)entity.getAttribute("abbreviation"));
        ret.setUsage((String)entity.getAttribute("usage"));
        ret.setAdditionalAttributes((Map)entity.getAttribute("additionalAttributes"));
        Object anchor = entity.getRelationshipAttribute("anchor");
        if (anchor instanceof AtlasRelatedObjectId) {
            LOG.debug("Processing anchor");
            ret.setAnchor(this.constructGlossaryId((AtlasRelatedObjectId)anchor));
        }
        if ((categories = entity.getRelationshipAttribute("categories")) instanceof Collection) {
            LOG.debug("Processing categories");
            for (Object category : (Collection)categories) {
                if (!(category instanceof AtlasRelatedObjectId)) continue;
                ret.addCategory(this.constructTermCategorizationId((AtlasRelatedObjectId)category));
            }
        }
        if ((assignedEntities = entity.getRelationshipAttribute("assignedEntities")) instanceof Collection) {
            LOG.debug("Processing assigned entities");
            for (Object assignedEntity : (Collection)assignedEntities) {
                AtlasRelatedObjectId id;
                if (!(assignedEntity instanceof AtlasRelatedObjectId) || (id = (AtlasRelatedObjectId)assignedEntity).getRelationshipStatus() != AtlasRelationship.Status.ACTIVE) continue;
                ret.addAssignedEntity(id);
            }
        }
        if ((seeAlso = entity.getRelationshipAttribute("seeAlso")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)seeAlso))) {
            LOG.debug("Processing RelatedTerm(seeAlso)");
            ret.setSeeAlso(this.toRelatedTermIdsSet(seeAlso));
        }
        if ((synonyms = entity.getRelationshipAttribute("synonyms")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)synonyms))) {
            LOG.debug("Processing Synonym(synonyms)");
            ret.setSynonyms(this.toRelatedTermIdsSet(synonyms));
        }
        if ((antonyms = entity.getRelationshipAttribute("antonyms")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)antonyms))) {
            LOG.debug("Processing Antonym(antonyms)");
            ret.setAntonyms(this.toRelatedTermIdsSet(antonyms));
        }
        if ((preferredTerms = entity.getRelationshipAttribute("preferredTerms")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)preferredTerms))) {
            LOG.debug("Processing preferredTerm(preferredTerms)");
            ret.setPreferredTerms(this.toRelatedTermIdsSet(preferredTerms));
        }
        if ((preferredToTerms = entity.getRelationshipAttribute("preferredToTerms")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)preferredToTerms))) {
            LOG.debug("Processing preferredTerm(preferredToTerms)");
            ret.setPreferredToTerms(this.toRelatedTermIdsSet(preferredToTerms));
        }
        if ((replacementTerms = entity.getRelationshipAttribute("replacementTerms")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)replacementTerms))) {
            LOG.debug("Processing ReplacementTerm(replacementTerms)");
            ret.setReplacementTerms(this.toRelatedTermIdsSet(replacementTerms));
        }
        if ((replacedBy = entity.getRelationshipAttribute("replacedBy")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)replacedBy))) {
            LOG.debug("Processing ReplacementTerm(replacedBy)");
            ret.setReplacedBy(this.toRelatedTermIdsSet(replacedBy));
        }
        if ((translationTerms = entity.getRelationshipAttribute("translationTerms")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)translationTerms))) {
            LOG.debug("Processing Translation(translationTerms)");
            ret.setTranslationTerms(this.toRelatedTermIdsSet(translationTerms));
        }
        if ((translatedTerms = entity.getRelationshipAttribute("translatedTerms")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)translatedTerms))) {
            LOG.debug("Processing Translation(translatedTerms)");
            ret.setTranslatedTerms(this.toRelatedTermIdsSet(translatedTerms));
        }
        if ((isA = entity.getRelationshipAttribute("isA")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)isA))) {
            LOG.debug("Processing Classifies(isA)");
            ret.setIsA(this.toRelatedTermIdsSet(isA));
        }
        if ((classifies = entity.getRelationshipAttribute("classifies")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)classifies))) {
            LOG.debug("Processing Classifies(classifies)");
            ret.setClassifies(this.toRelatedTermIdsSet(classifies));
        }
        if ((validValues = entity.getRelationshipAttribute("validValues")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)validValues))) {
            LOG.debug("Processing validValue(validValues)");
            ret.setValidValues(this.toRelatedTermIdsSet(validValues));
        }
        if ((validValuesFor = entity.getRelationshipAttribute("validValuesFor")) instanceof Collection && CollectionUtils.isNotEmpty((Collection)((Collection)validValuesFor))) {
            LOG.debug("Processing validValue(validValuesFor)");
            ret.setValidValuesFor(this.toRelatedTermIdsSet(validValuesFor));
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getClassifications())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing term classifications");
            }
            ret.setClassifications(entity.getClassifications());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryTermDTO.from() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasGlossaryTerm from(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryTermDTO.from()", (Object)entityWithExtInfo);
        }
        Objects.requireNonNull(entityWithExtInfo, "entityWithExtInfo");
        AtlasGlossaryTerm ret = this.from(entityWithExtInfo.getEntity());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryTermDTO.from() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntity toEntity(AtlasGlossaryTerm obj) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryTermDTO.toEntity()", (Object)obj);
        }
        Objects.requireNonNull(obj, "atlasGlossaryTerm");
        Objects.requireNonNull(obj.getQualifiedName(), "atlasGlossaryTerm qualifiedName must be specified");
        Objects.requireNonNull(obj.getAnchor(), "atlasGlossaryTerm anchor must be specified");
        AtlasEntity ret = this.getDefaultAtlasEntity(obj);
        ret.setAttribute("qualifiedName", (Object)obj.getQualifiedName());
        ret.setAttribute("name", (Object)obj.getName());
        ret.setAttribute("shortDescription", (Object)obj.getShortDescription());
        ret.setAttribute("longDescription", (Object)obj.getLongDescription());
        ret.setAttribute("examples", (Object)obj.getExamples());
        ret.setAttribute("abbreviation", (Object)obj.getAbbreviation());
        ret.setAttribute("usage", (Object)obj.getUsage());
        ret.setAttribute("anchor", (Object)new AtlasObjectId(obj.getAnchor().getGlossaryGuid()));
        ret.setAttribute("additionalAttributes", (Object)obj.getAdditionalAttributes());
        if (CollectionUtils.isNotEmpty((Collection)obj.getClassifications())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing term classifications");
            }
            ret.setClassifications(obj.getClassifications());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryTermDTO.toEntity() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo toEntityWithExtInfo(AtlasGlossaryTerm obj) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasGlossaryTermDTO.toEntityWithExtInfo()", (Object)obj);
        }
        Objects.requireNonNull(obj, "atlasGlossaryTerm");
        AtlasEntity entity = this.toEntity(obj);
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasGlossaryTermDTO.toEntityWithExtInfo() : {}", (Object)ret);
        }
        return ret;
    }

    @Override
    public Map<String, Object> getUniqueAttributes(AtlasGlossaryTerm obj) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("qualifiedName", obj.getQualifiedName());
        return ret;
    }
}

