/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.AbstractWarningVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;

public final class EdgeLabelVerificationStrategy
extends AbstractWarningVerificationStrategy {
    private EdgeLabelVerificationStrategy(Builder builder) {
        super(builder);
    }

    @Override
    void verify(Traversal.Admin<?, ?> traversal) throws VerificationException {
        for (Step step : traversal.getSteps()) {
            if (!(step instanceof VertexStep) || ((VertexStep)step).getEdgeLabels().length != 0) continue;
            String msg = String.format("The provided traversal contains a vertex step without any specified edge label: %s\nAlways specify edge labels which restrict traversal paths ensuring optimal performance.", step);
            throw new VerificationException(msg, traversal);
        }
    }

    public static EdgeLabelVerificationStrategy create(Configuration configuration) {
        return ((Builder)((Builder)EdgeLabelVerificationStrategy.build().throwException(configuration.getBoolean("throwException", false))).logWarning(configuration.getBoolean("logWarning", false))).create();
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractWarningVerificationStrategy.Builder<EdgeLabelVerificationStrategy, Builder> {
        private Builder() {
        }

        @Override
        public EdgeLabelVerificationStrategy create() {
            return new EdgeLabelVerificationStrategy(this);
        }
    }
}

