/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.internal;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class Token {
    public static final char SEPARATOR_CHAR = '\u001e';
    public static final String systemETprefix = Graph.Hidden.hide((String)"T$");
    public static final String NONEXISTENT_TYPE = systemETprefix + "doesNotExist";
    public static final String INTERNAL_INDEX_NAME = "internalindex";

    public static String getSeparatedName(String ... components) {
        for (String component : components) {
            Token.verifyName(component);
        }
        return StringUtils.join((Object[])components, (char)'\u001e');
    }

    public static void verifyName(String name) {
        Preconditions.checkArgument((name.indexOf(30) < 0 ? 1 : 0) != 0, (String)"Name can not contains reserved character %s: %s", (Object[])new Object[]{Character.valueOf('\u001e'), name});
    }

    public static String[] splitSeparatedName(String name) {
        return name.split("\u001e");
    }

    public static boolean isSystemName(String name) {
        return Graph.Hidden.isHidden((String)name);
    }

    public static String makeSystemName(String name) {
        return Graph.Hidden.hide((String)name);
    }
}

