/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.janusgraph.core.InvalidElementException;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.internal.AbstractElement;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.EdgeDirection;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.relations.RelationIdentifierUtils;
import org.janusgraph.graphdb.relations.SimpleJanusGraphProperty;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public abstract class AbstractTypedRelation
extends AbstractElement
implements InternalRelation {
    protected final InternalRelationType type;

    public AbstractTypedRelation(long id, RelationType type) {
        super(id);
        assert (type != null && type instanceof InternalRelationType);
        this.type = (InternalRelationType)type;
    }

    @Override
    public InternalRelation it() {
        if (this.isLoadedInThisTx()) {
            return this;
        }
        InternalRelation next = (InternalRelation)RelationIdentifierUtils.findRelation(RelationIdentifierUtils.get(this), this.tx());
        if (next == null) {
            throw InvalidElementException.removedException(this);
        }
        return next;
    }

    private boolean isLoadedInThisTx() {
        InternalVertex v = this.getVertex(0);
        return v == v.it();
    }

    @Override
    public final StandardJanusGraphTx tx() {
        return this.getVertex(0).tx();
    }

    protected final void verifyAccess() {
    }

    @Override
    public Direction direction(Vertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.it().getVertex(i).equals(vertex)) continue;
            return EdgeDirection.fromPosition(i);
        }
        throw new IllegalArgumentException("Relation is not incident on vertex");
    }

    @Override
    public boolean isIncidentOn(Vertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.it().getVertex(i).equals(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInvisible() {
        return this.type.isInvisibleType();
    }

    @Override
    public boolean isLoop() {
        return this.getArity() == 2 && this.getVertex(0).equals(this.getVertex(1));
    }

    @Override
    public RelationType getType() {
        return this.type;
    }

    public RelationIdentifier id() {
        return RelationIdentifierUtils.get(this);
    }

    @Override
    public <V> Property<V> property(String key, V value) {
        this.verifyAccess();
        PropertyKey propertyKey = this.tx().getOrCreatePropertyKey(key, value);
        Object normalizedValue = this.tx().verifyAttribute(propertyKey, value);
        this.it().setPropertyDirect(propertyKey, normalizedValue);
        return new SimpleJanusGraphProperty<V>(this, propertyKey, value);
    }

    public <O> O valueOrNull(PropertyKey key) {
        this.verifyAccess();
        if (key instanceof ImplicitKey) {
            return ((ImplicitKey)key).computeProperty(this);
        }
        return this.it().getValueDirect(key);
    }

    public <O> O value(String key) {
        this.verifyAccess();
        O val = this.valueInternal(this.tx().getPropertyKey(key));
        if (val == null) {
            throw Property.Exceptions.propertyDoesNotExist((Element)this, (String)key);
        }
        return val;
    }

    private <O> O valueInternal(PropertyKey type) {
        if (type == null) {
            return null;
        }
        return this.valueOrNull(type);
    }

    public <V> Iterator<Property<V>> properties(String ... keyNames) {
        this.verifyAccess();
        Stream<PropertyKey> keys = keyNames == null || keyNames.length == 0 ? IteratorUtils.stream(this.it().getPropertyKeysDirect().iterator()) : Stream.of(keyNames).map(s -> this.tx().getPropertyKey((String)s)).filter(rt -> rt != null && this.getValueDirect((PropertyKey)rt) != null);
        return keys.map(rt -> new SimpleJanusGraphProperty(this, (PropertyKey)rt, this.valueInternal((PropertyKey)rt))).iterator();
    }
}

