/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphLocalQueryOptimizerStrategy;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public abstract class AdjacentVertexOptimizerStrategy<T extends FilterStep<?>>
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPost() {
        HashSet<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> postStrategies = new HashSet<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>>();
        postStrategies.add(JanusGraphLocalQueryOptimizerStrategy.class);
        return postStrategies;
    }

    protected void optimizeStep(T step) {
        P<?> predicate = this.parsePredicate(step);
        if (this.isValidPredicate(predicate)) {
            OptimizablePosition pos = this.getOptimizablePosition(step);
            this.replaceSequence(step, pos, predicate);
        }
    }

    protected abstract P<?> parsePredicate(T var1);

    protected abstract boolean isValidPredicate(P<?> var1);

    private OptimizablePosition getOptimizablePosition(T originalStep) {
        Step predecessor = originalStep.getPreviousStep();
        if (predecessor instanceof VertexStep) {
            if (((VertexStep)predecessor).returnsVertex()) {
                return OptimizablePosition.V2V_ID;
            }
            return OptimizablePosition.NONE;
        }
        Step prePredecessor = predecessor.getPreviousStep();
        if ((predecessor instanceof EdgeVertexStep || predecessor instanceof EdgeOtherVertexStep) && prePredecessor instanceof VertexStep && ((VertexStep)prePredecessor).returnsEdge()) {
            return OptimizablePosition.V2E_E2V_ID;
        }
        return OptimizablePosition.NONE;
    }

    private void replaceSequence(T originalStep, OptimizablePosition pos, P<?> predicate) {
        switch (pos) {
            case V2E_E2V_ID: {
                this.replaceSequenceV2EthenE2VthenID(originalStep, predicate);
                break;
            }
            case V2V_ID: {
                this.replaceSequenceV2VthenID(originalStep, predicate);
                break;
            }
        }
    }

    private void replaceSequenceV2EthenE2VthenID(T originalStep, P<?> predicate) {
        Traversal.Admin traversal = originalStep.getTraversal();
        Step e2vStep = originalStep.getPreviousStep();
        originalStep.getLabels().forEach(arg_0 -> ((Step)e2vStep).addLabel(arg_0));
        HasStep<Edge> hasAdjacentIdStep = this.makeHasAdjacentIdStep(traversal, predicate);
        traversal.removeStep(originalStep);
        TraversalHelper.insertBeforeStep(hasAdjacentIdStep, (Step)e2vStep, (Traversal.Admin)traversal);
    }

    private void replaceSequenceV2VthenID(T originalStep, P<?> predicate) {
        Traversal.Admin traversal = originalStep.getTraversal();
        VertexStep v2vStep = (VertexStep)originalStep.getPreviousStep();
        String[] edgeLabels = v2vStep.getEdgeLabels();
        Direction v2vDirection = v2vStep.getDirection();
        VertexStep v2eStep = new VertexStep(traversal, Edge.class, v2vDirection, edgeLabels);
        Object e2vStep = v2vDirection == Direction.BOTH ? new EdgeOtherVertexStep(traversal) : new EdgeVertexStep(traversal, v2vDirection.opposite());
        originalStep.getLabels().forEach(arg_0 -> ((Step)e2vStep).addLabel(arg_0));
        Step predecessor = v2vStep.getPreviousStep();
        HasStep<Edge> hasAdjacentIdStep = this.makeHasAdjacentIdStep(traversal, predicate);
        traversal.removeStep(originalStep);
        traversal.removeStep((Step)v2vStep);
        TraversalHelper.insertAfterStep((Step)v2eStep, (Step)predecessor, (Traversal.Admin)traversal);
        TraversalHelper.insertAfterStep(hasAdjacentIdStep, (Step)v2eStep, (Traversal.Admin)traversal);
        TraversalHelper.insertAfterStep((Step)e2vStep, hasAdjacentIdStep, (Traversal.Admin)traversal);
    }

    private HasStep<Edge> makeHasAdjacentIdStep(Traversal.Admin<?, ?> traversal, P<?> predicate) {
        HasContainer hc = new HasContainer(ImplicitKey.ADJACENT_ID.name(), P.eq((Object)predicate.getValue()));
        return new HasStep(traversal, new HasContainer[]{hc});
    }

    protected static enum OptimizablePosition {
        NONE,
        V2V_ID,
        V2E_E2V_ID;

    }
}

