/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.cql;

import com.datastax.driver.core.Row;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.hadoop.cql3.CqlRecordReader;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;

public class CqlBinaryRecordReader
extends RecordReader<StaticBuffer, Iterable<Entry>> {
    private KV currentKV;
    private KV incompleteKV;
    private final CqlRecordReader reader;

    public CqlBinaryRecordReader(CqlRecordReader reader) {
        this.reader = reader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        this.reader.initialize(inputSplit, taskAttemptContext);
    }

    public boolean nextKeyValue() throws IOException {
        this.currentKV = this.completeNextKV();
        return null != this.currentKV;
    }

    private KV completeNextKV() throws IOException {
        boolean hasNext;
        KV completedKV = null;
        do {
            if (!(hasNext = this.reader.nextKeyValue())) {
                completedKV = this.incompleteKV;
                this.incompleteKV = null;
                continue;
            }
            Row row = this.reader.getCurrentValue();
            StaticArrayBuffer key = StaticArrayBuffer.of((ByteBuffer)row.getBytesUnsafe("key"));
            StaticArrayBuffer column1 = StaticArrayBuffer.of((ByteBuffer)row.getBytesUnsafe("column1"));
            StaticArrayBuffer value = StaticArrayBuffer.of((ByteBuffer)row.getBytesUnsafe("value"));
            Entry entry = StaticArrayEntry.of((StaticBuffer)column1, (StaticBuffer)value);
            if (null == this.incompleteKV) {
                this.incompleteKV = new KV(key);
            } else if (!this.incompleteKV.key.equals((Object)key)) {
                completedKV = this.incompleteKV;
                this.incompleteKV = new KV(key);
            }
            this.incompleteKV.addEntry(entry);
        } while (hasNext && null == completedKV);
        return completedKV;
    }

    public StaticBuffer getCurrentKey() {
        return this.currentKV.key;
    }

    public Iterable<Entry> getCurrentValue() {
        return this.currentKV.entries;
    }

    public void close() {
        this.reader.close();
    }

    public float getProgress() {
        return this.reader.getProgress();
    }

    private static class KV {
        private final StaticArrayBuffer key;
        private ArrayList<Entry> entries = new ArrayList();

        public KV(StaticArrayBuffer key) {
            this.key = key;
        }

        public void addEntry(Entry toAdd) {
            this.entries.add(toAdd);
        }
    }
}

