/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.mapping;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.model.Column;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.UUID;

class Coercions {
    static <T> void setFieldFromColumn(T instance, Field field, Column<String> column) {
        Object objValue = null;
        if (field.getType() == Byte.class || field.getType() == Byte.TYPE) {
            objValue = (byte)(column.getIntegerValue() & 0xFF);
        } else if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
            objValue = column.getBooleanValue();
        } else if (field.getType() == Short.class || field.getType() == Short.TYPE) {
            objValue = (short)(column.getIntegerValue() & 0xFF);
        } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
            objValue = column.getIntegerValue();
        } else if (field.getType() == Long.class || field.getType() == Long.TYPE) {
            objValue = column.getLongValue();
        } else if (field.getType() == Float.class || field.getType() == Float.TYPE) {
            objValue = Float.valueOf((float)column.getDoubleValue());
        } else if (field.getType() == Double.class || field.getType() == Double.TYPE) {
            objValue = column.getDoubleValue();
        } else if (field.getType() == Date.class) {
            objValue = column.getDateValue();
        } else if (field.getType() == String.class) {
            objValue = column.getStringValue();
        } else if (field.getType() == byte[].class) {
            objValue = column.getByteArrayValue();
        } else if (field.getType() == UUID.class) {
            objValue = column.getUUIDValue();
        } else if (field.getType().isEnum()) {
            objValue = Enum.valueOf(field.getType(), column.getStringValue());
        }
        if (objValue == null) {
            throw new UnsupportedOperationException("Field datatype not supported: " + field.getType().getCanonicalName());
        }
        try {
            field.set(instance, objValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> void setColumnMutationFromField(T instance, Field field, String columnName, ColumnListMutation<String> mutation) {
        block14: {
            try {
                Object objValue = field.get(instance);
                if (objValue == null) break block14;
                if (objValue.getClass() == Byte.class || objValue.getClass() == Byte.TYPE) {
                    mutation.putColumn(columnName, (int)((Byte)objValue & 0xFF), (Integer)null);
                    break block14;
                }
                if (objValue.getClass() == Boolean.class || objValue.getClass() == Boolean.TYPE) {
                    mutation.putColumn(columnName, (Boolean)objValue, null);
                    break block14;
                }
                if (objValue.getClass() == Short.class || objValue.getClass() == Short.TYPE) {
                    mutation.putColumn(columnName, (Short)objValue, null);
                    break block14;
                }
                if (objValue.getClass() == Integer.class || objValue.getClass() == Integer.TYPE) {
                    mutation.putColumn(columnName, (Integer)objValue, null);
                    break block14;
                }
                if (objValue.getClass() == Long.class || objValue.getClass() == Long.TYPE) {
                    mutation.putColumn(columnName, (Long)objValue, null);
                    break block14;
                }
                if (objValue.getClass() == Float.class || objValue.getClass() == Float.TYPE) {
                    mutation.putColumn(columnName, ((Float)objValue).floatValue(), (Integer)null);
                    break block14;
                }
                if (objValue.getClass() == Double.class || objValue.getClass() == Double.TYPE) {
                    mutation.putColumn(columnName, (Double)objValue, null);
                    break block14;
                }
                if (objValue.getClass() == Date.class) {
                    mutation.putColumn(columnName, (Date)objValue, null);
                    break block14;
                }
                if (objValue.getClass() == String.class) {
                    mutation.putColumn(columnName, (String)objValue, null);
                    break block14;
                }
                if (objValue.getClass() == byte[].class) {
                    mutation.putColumn(columnName, (byte[])objValue, null);
                    break block14;
                }
                if (objValue.getClass() == UUID.class) {
                    mutation.putColumn(columnName, (UUID)objValue, null);
                    break block14;
                }
                if (objValue.getClass().isEnum()) {
                    mutation.putColumn(columnName, objValue.toString(), null);
                    break block14;
                }
                throw new UnsupportedOperationException("Column datatype not supported: " + objValue.getClass().getCanonicalName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Coercions() {
    }
}

