/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Equality;
import com.netflix.astyanax.serializers.ByteBufferOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class CompositeRangeBuilder
implements ByteBufferRange {
    private ByteBufferOutputStream start = new ByteBufferOutputStream();
    private ByteBufferOutputStream end = new ByteBufferOutputStream();
    private int limit = Integer.MAX_VALUE;
    private boolean reversed = false;
    private boolean lockComponent = false;
    private List<RangeQueryRecord> records = new ArrayList<RangeQueryRecord>();

    protected void nextComponent() {
        this.getNextComponent();
        this.records.add(new RangeQueryRecord());
    }

    protected abstract void getNextComponent();

    protected abstract void append(ByteBufferOutputStream var1, Object var2, Equality var3);

    public CompositeRangeBuilder withPrefix(Object object) {
        if (this.lockComponent) {
            throw new IllegalStateException("Prefix cannot be added once equality has been specified");
        }
        this.append(this.start, object, Equality.EQUAL);
        this.append(this.end, object, Equality.EQUAL);
        this.getLastRecord().addQueryOp(object, Equality.EQUAL);
        this.nextComponent();
        return this;
    }

    public CompositeRangeBuilder limit(int count) {
        this.limit = count;
        return this;
    }

    public CompositeRangeBuilder reverse() {
        this.reversed = true;
        ByteBufferOutputStream temp = this.start;
        this.start = this.end;
        this.end = temp;
        return this;
    }

    public CompositeRangeBuilder greaterThan(Object value) {
        this.lockComponent = true;
        this.append(this.start, value, Equality.GREATER_THAN);
        this.getLastRecord().addQueryOp(value, Equality.GREATER_THAN);
        return this;
    }

    public CompositeRangeBuilder greaterThanEquals(Object value) {
        this.lockComponent = true;
        this.append(this.start, value, Equality.GREATER_THAN_EQUALS);
        this.getLastRecord().addQueryOp(value, Equality.GREATER_THAN_EQUALS);
        return this;
    }

    public CompositeRangeBuilder lessThan(Object value) {
        this.lockComponent = true;
        this.append(this.end, value, Equality.LESS_THAN);
        this.getLastRecord().addQueryOp(value, Equality.LESS_THAN);
        return this;
    }

    public CompositeRangeBuilder lessThanEquals(Object value) {
        this.lockComponent = true;
        this.append(this.end, value, Equality.LESS_THAN_EQUALS);
        this.getLastRecord().addQueryOp(value, Equality.LESS_THAN_EQUALS);
        return this;
    }

    private RangeQueryRecord getLastRecord() {
        if (this.records.size() == 0) {
            RangeQueryRecord record = new RangeQueryRecord();
            this.records.add(record);
        }
        return this.records.get(this.records.size() - 1);
    }

    @Override
    @Deprecated
    public ByteBuffer getStart() {
        return this.start.getByteBuffer();
    }

    @Override
    @Deprecated
    public ByteBuffer getEnd() {
        return this.end.getByteBuffer();
    }

    @Override
    @Deprecated
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    @Deprecated
    public int getLimit() {
        return this.limit;
    }

    public CompositeByteBufferRange build() {
        return new CompositeByteBufferRange(this.start, this.end, this.limit, this.reversed, this.records);
    }

    public static class CompositeByteBufferRange
    implements ByteBufferRange {
        private final ByteBufferOutputStream start;
        private final ByteBufferOutputStream end;
        private int limit;
        private boolean reversed;
        private final List<RangeQueryRecord> records;

        private CompositeByteBufferRange(ByteBufferOutputStream rangeStart, ByteBufferOutputStream rangeEnd, int rangeLimit, boolean rangeReversed, List<RangeQueryRecord> rangeRecords) {
            this.start = rangeStart;
            this.end = rangeEnd;
            this.limit = rangeLimit;
            this.reversed = rangeReversed;
            this.records = rangeRecords;
        }

        public CompositeByteBufferRange(int rangeLimit, boolean rangeReversed, List<RangeQueryRecord> rangeRecords) {
            this.start = null;
            this.end = null;
            this.limit = rangeLimit;
            this.reversed = rangeReversed;
            this.records = rangeRecords;
        }

        @Override
        public ByteBuffer getStart() {
            return this.start.getByteBuffer();
        }

        @Override
        public ByteBuffer getEnd() {
            return this.end.getByteBuffer();
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        public List<RangeQueryRecord> getRecords() {
            return this.records;
        }
    }

    public static class RangeQueryOp {
        private final Object value;
        private final Equality operator;

        public RangeQueryOp(Object value, Equality operator) {
            this.value = value;
            this.operator = operator;
        }

        public Object getValue() {
            return this.value;
        }

        public Equality getOperator() {
            return this.operator;
        }
    }

    public static class RangeQueryRecord {
        private List<RangeQueryOp> ops = new ArrayList<RangeQueryOp>();

        public void addQueryOp(Object value, Equality operator) {
            this.add(new RangeQueryOp(value, operator));
        }

        public void add(RangeQueryOp rangeOp) {
            this.ops.add(rangeOp);
        }

        public List<RangeQueryOp> getOps() {
            return this.ops;
        }
    }
}

