/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.ReversedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ReversedType;
import java.nio.ByteBuffer;

public class SpecificReversedSerializer
extends ReversedSerializer {
    private String reversedTypeName;
    private final ComparatorType reversedComparatorType;

    public SpecificReversedSerializer(ReversedType type) {
        Preconditions.checkNotNull((Object)type);
        AbstractType compType = type.baseType;
        this.reversedTypeName = compType.toString();
        this.reversedTypeName = ComparatorType.getShadedTypeName(this.reversedTypeName);
        this.reversedComparatorType = ComparatorType.getByClassName(this.reversedTypeName);
    }

    @Override
    public ByteBuffer fromString(String string) {
        return this.reversedComparatorType.getSerializer().fromString(string);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return this.reversedComparatorType.getSerializer().getString(byteBuffer);
    }
}

