/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.SerializerPackage;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.SerializerPackageImpl;
import com.netflix.astyanax.serializers.UnknownComparatorException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import com.netflix.astyanax.util.RecordWriter;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class ColumnarRecordWriter
implements RecordWriter {
    private Keyspace keyspace;
    private SerializerPackage serializers;
    private ColumnFamily<ByteBuffer, ByteBuffer> cf;
    private int batchSize = 1;
    private MutationBatch mutation;

    public ColumnarRecordWriter(Keyspace keyspace, String cfName) {
        this.keyspace = keyspace;
        this.cf = new ColumnFamily<ByteBuffer, ByteBuffer>(cfName, ByteBufferSerializer.get(), ByteBufferSerializer.get());
        try {
            this.serializers = keyspace.getSerializerPackage(cfName, true);
        }
        catch (ConnectionException e) {
            this.serializers = SerializerPackageImpl.DEFAULT_SERIALIZER_PACKAGE;
        }
        catch (UnknownComparatorException unknownComparatorException) {
            // empty catch block
        }
    }

    public ColumnarRecordWriter(Keyspace keyspace, String cfName, SerializerPackage serializers) {
        this.keyspace = keyspace;
        this.serializers = serializers;
        this.cf = new ColumnFamily<ByteBuffer, ByteBuffer>(cfName, ByteBufferSerializer.get(), ByteBufferSerializer.get());
    }

    public ColumnarRecordWriter setBatchSize(int size) {
        this.batchSize = size;
        return this;
    }

    @Override
    public void start() throws ConnectionException {
        this.mutation = this.keyspace.prepareMutationBatch();
    }

    @Override
    public void write(List<Pair<String, String>> record) {
        if (record.size() <= 1) {
            return;
        }
        Iterator<Pair<String, String>> iter = record.iterator();
        ByteBuffer rowKey = this.serializers.keyAsByteBuffer((String)iter.next().right);
        ColumnListMutation<ByteBuffer> rowMutation = this.mutation.withRow(this.cf, rowKey);
        while (iter.hasNext()) {
            Pair<String, String> pair = iter.next();
            try {
                rowMutation.putColumn(this.serializers.columnAsByteBuffer((String)pair.left), this.serializers.valueAsByteBuffer((String)pair.left, (String)pair.right), null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.batchSize == this.mutation.getRowCount()) {
            try {
                this.mutation.execute();
            }
            catch (ConnectionException e) {
                this.mutation.discardMutations();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.mutation.getRowCount() > 0) {
            try {
                this.mutation.execute();
            }
            catch (ConnectionException e) {
                this.mutation.discardMutations();
            }
        }
    }
}

