/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.astyanax.ExceptionCallback;
import com.netflix.astyanax.SerializerPackage;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.util.RowsWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;

public class JsonRowsWriter
implements RowsWriter {
    private Map<Field, String> fieldNames = Maps.newHashMap();
    private static final String TIME_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final PrintWriter out;
    private final SerializerPackage serializers;
    private String extra = null;
    private boolean rowsAsArray = true;
    private boolean ignoreExceptions = true;
    private boolean ignoreUndefinedColumns = false;
    private Set<String> dynamicNames;
    private Set<String> fixedNames;
    private List<String> fixedNamesList;
    private Set<String> ignoreNames = Sets.newHashSet();
    private Set<String> metadataNames;
    private boolean columnsAsRows = false;
    private int rowCount = 0;
    private int columnCount = 0;
    private int maxStringLength = 256;
    private String rowColumnDelimiter = "$";

    public JsonRowsWriter(PrintWriter out, SerializerPackage serializers) throws ConnectionException {
        this.out = out;
        this.serializers = serializers;
        this.fieldNames.put(Field.NAMES, "names");
        this.fieldNames.put(Field.ROWS, "rows");
        this.fieldNames.put(Field.COUNT, "count");
        this.fieldNames.put(Field.ROW_KEY, "_key");
        this.fieldNames.put(Field.COLUMN, "column");
        this.fieldNames.put(Field.TIMESTAMP, "timestamp");
        this.fieldNames.put(Field.VALUE, "value");
        this.fieldNames.put(Field.TTL, "ttl");
    }

    public JsonRowsWriter setRowsName(String fieldName) {
        this.fieldNames.put(Field.ROWS, fieldName);
        return this;
    }

    public JsonRowsWriter setNamesName(String fieldName) {
        this.fieldNames.put(Field.NAMES, fieldName);
        return this;
    }

    public JsonRowsWriter setCountName(String fieldName) {
        this.fieldNames.put(Field.COUNT, fieldName);
        return this;
    }

    public JsonRowsWriter setRowKeyName(String fieldName) {
        this.fieldNames.put(Field.ROW_KEY, fieldName);
        return this;
    }

    public JsonRowsWriter setExtra(String extra) {
        this.extra = extra;
        return this;
    }

    public JsonRowsWriter setRowsAsArray(boolean flag) {
        this.rowsAsArray = flag;
        return this;
    }

    public JsonRowsWriter setIgnoreUndefinedColumns(boolean flag) {
        this.ignoreUndefinedColumns = flag;
        return this;
    }

    @Deprecated
    public JsonRowsWriter setErrorValueText(String text) {
        return this;
    }

    public JsonRowsWriter setDynamicColumnNames(boolean flag) {
        this.dynamicNames = flag ? Sets.newLinkedHashSet() : null;
        return this;
    }

    public JsonRowsWriter setFixedColumnNames(String ... columns) {
        this.fixedNames = Sets.newLinkedHashSet(Arrays.asList(columns));
        this.fixedNamesList = Arrays.asList(columns);
        return this;
    }

    public JsonRowsWriter setIgnoreColumnNames(String ... columns) {
        this.ignoreNames = Sets.newHashSet(Arrays.asList(columns));
        return this;
    }

    @Deprecated
    public JsonRowsWriter setExceptionCallback(ExceptionCallback exceptionCallback) {
        return this;
    }

    public JsonRowsWriter setColumnsAsRows(boolean columnsAsRows) {
        this.columnsAsRows = columnsAsRows;
        this.setFixedColumnNames("column", "value", "timestamp", "ttl");
        return this;
    }

    public JsonRowsWriter addExtra(String name, String value) {
        if (this.extra == null) {
            this.extra = new String();
        }
        if (!this.extra.isEmpty()) {
            this.extra = this.extra + ",";
        }
        this.extra = this.extra + this.jsonifyString(name) + ":" + this.jsonifyString(value);
        return this;
    }

    public JsonRowsWriter setMaxLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        return this;
    }

    int getColumnCount() {
        return this.columnCount;
    }

    int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void write(Rows<?, ?> rows) throws Exception {
        boolean firstRow;
        this.rowCount = 0;
        this.columnCount = 0;
        this.out.println("{");
        if (this.fixedNamesList != null) {
            this.writeColumnNames(this.fixedNamesList);
        } else if (this.dynamicNames == null) {
            this.metadataNames = this.getColumnNamesFromMetadata();
            ArrayList names = Lists.newArrayList(this.metadataNames);
            Collections.sort(names);
            this.writeColumnNames(names);
        }
        this.out.append(this.jsonifyString(this.fieldNames.get((Object)Field.ROWS))).append(":");
        int count = 0;
        if (this.columnsAsRows) {
            this.addExtra("columnsAsRows", "true");
            if (this.rowsAsArray) {
                this.out.append("[");
            }
            firstRow = true;
            for (Row row : rows) {
                if (row.getColumns().isEmpty()) continue;
                ++this.rowCount;
                String idString = this.serializers.keyAsString(row.getRawKey());
                count += this.writeColumnsAsRows(idString, row.getColumns(), firstRow);
                firstRow = false;
            }
            if (this.rowsAsArray) {
                this.out.append("]");
            }
            this.out.println();
        } else if (this.rowsAsArray) {
            this.out.append("[").println();
            firstRow = true;
            for (Row row : rows) {
                block22: {
                    if (row.getColumns().isEmpty()) continue;
                    ++this.rowCount;
                    if (!firstRow) {
                        this.out.println(",");
                    } else {
                        firstRow = false;
                    }
                    this.out.append("{");
                    try {
                        String idString = this.serializers.keyAsString(row.getRawKey());
                        this.out.append(this.jsonifyString(this.fieldNames.get((Object)Field.ROW_KEY))).append(":").append(this.jsonifyString(idString));
                        this.writeColumns(row.getColumns(), false);
                        ++count;
                    }
                    catch (Exception e) {
                        if (this.ignoreExceptions) break block22;
                        throw e;
                    }
                }
                this.out.print("}");
            }
            this.out.println();
            this.out.append("]");
        } else {
            this.out.append("{").println();
            firstRow = true;
            for (Row row : rows) {
                if (row.getColumns().isEmpty()) continue;
                ++this.rowCount;
                if (!firstRow) {
                    this.out.println(",");
                } else {
                    firstRow = false;
                }
                try {
                    String idString = this.serializers.keyAsString(row.getRawKey());
                    this.out.append(this.jsonifyString(idString)).append(":{");
                    this.writeColumns(row.getColumns(), true);
                    this.out.print("}");
                    ++count;
                }
                catch (Exception e) {
                    if (this.ignoreExceptions) continue;
                    throw e;
                }
            }
            this.out.println();
            this.out.append("}");
        }
        this.out.println(",");
        if (this.dynamicNames != null) {
            ArrayList names = Lists.newArrayList(this.dynamicNames);
            Collections.sort(names);
            this.writeColumnNames(names);
        }
        if (this.extra != null) {
            this.out.append(this.extra).println(",");
        }
        this.out.append(this.jsonifyString(this.fieldNames.get((Object)Field.COUNT))).append(":").append(Integer.toString(count)).println();
        this.out.println("}");
    }

    private int writeColumnsAsRows(String rowKey, ColumnList<?> columns, boolean first) throws Exception {
        for (Column column : columns) {
            try {
                int ttl;
                String timestampString;
                String columnString;
                try {
                    columnString = this.serializers.columnAsString(column.getRawName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.ignoreExceptions) {
                        throw e;
                    }
                    columnString = e.getMessage();
                }
                String valueString = null;
                try {
                    valueString = this.serializers.valueAsString(column.getRawName(), column.getByteBufferValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.ignoreExceptions) {
                        throw e;
                    }
                    valueString = e.getMessage();
                }
                if (!first) {
                    this.out.println(",");
                } else {
                    first = false;
                }
                this.out.append("{");
                if (this.rowsAsArray) {
                    this.out.append(this.jsonifyString(this.fieldNames.get((Object)Field.ROW_KEY))).append(":").append(this.jsonifyString(rowKey));
                } else {
                    this.out.append(this.jsonifyString(rowKey + this.rowColumnDelimiter + columnString)).append(":{");
                }
                this.out.print(",");
                try {
                    timestampString = new SimpleDateFormat(TIME_FORMAT_STRING).format(new Date(column.getTimestamp() / 1000L));
                }
                catch (Exception e) {
                    timestampString = "none";
                }
                try {
                    ttl = column.getTtl();
                }
                catch (Exception e) {
                    ttl = 0;
                }
                ++this.columnCount;
                this.out.append(this.jsonifyString(this.fieldNames.get((Object)Field.COLUMN))).append(":").append(this.jsonifyString(columnString)).append(",").append(this.jsonifyString(this.fieldNames.get((Object)Field.VALUE))).append(":").append(this.jsonifyString(valueString)).append(",").append(this.jsonifyString(this.fieldNames.get((Object)Field.TIMESTAMP))).append(":").append(this.jsonifyString(timestampString)).append(",").append(this.jsonifyString(this.fieldNames.get((Object)Field.TTL))).append(":").append(this.jsonifyString(Integer.toString(ttl))).append("}");
            }
            catch (Exception e) {
                if (this.ignoreExceptions) continue;
                throw e;
            }
        }
        return columns.size();
    }

    private void writeColumns(ColumnList<?> columns, boolean first) throws Exception {
        for (Column column : columns) {
            try {
                String columnString;
                try {
                    columnString = this.serializers.columnAsString(column.getRawName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.ignoreExceptions) {
                        throw e;
                    }
                    columnString = e.getMessage();
                }
                if (this.ignoreNames.contains(columnString) || this.ignoreUndefinedColumns && (this.fixedNames != null && !this.fixedNames.contains(columnString) || this.metadataNames != null && !this.metadataNames.contains(columnString))) continue;
                if (this.dynamicNames != null) {
                    this.dynamicNames.add(columnString);
                }
                String valueString = null;
                try {
                    valueString = this.serializers.valueAsString(column.getRawName(), column.getByteBufferValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.ignoreExceptions) {
                        throw e;
                    }
                    valueString = e.getMessage();
                }
                if (!first) {
                    this.out.append(",");
                } else {
                    first = false;
                }
                this.out.append(this.jsonifyString(columnString)).append(":").append(this.jsonifyString(valueString));
            }
            catch (Exception e) {
                if (this.ignoreExceptions) continue;
                throw e;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getColumnNamesFromMetadata() throws Exception {
        LinkedHashSet set = Sets.newLinkedHashSet();
        try {
            for (ByteBuffer name : this.serializers.getColumnNames()) {
                try {
                    String columnName = this.serializers.columnAsString(name);
                    set.add(columnName);
                }
                catch (Exception e) {
                    if (this.ignoreExceptions) continue;
                    throw e;
                    return set;
                }
            }
        }
        catch (Exception e) {
            if (this.ignoreExceptions) return set;
            throw e;
        }
    }

    private void writeColumnNames(List<String> names) throws Exception {
        block8: {
            try {
                this.out.append(this.jsonifyString(this.fieldNames.get((Object)Field.NAMES))).append(":[");
                boolean first = true;
                if (this.rowsAsArray) {
                    this.out.append(this.jsonifyString(this.fieldNames.get((Object)Field.ROW_KEY)));
                    first = false;
                }
                for (String name : names) {
                    if (this.ignoreNames.contains(name)) continue;
                    try {
                        if (!first) {
                            this.out.append(",");
                        } else {
                            first = false;
                        }
                        this.out.append(this.jsonifyString(name));
                    }
                    catch (Exception exception) {}
                }
                this.out.println("],");
            }
            catch (Exception e) {
                if (this.ignoreExceptions) break block8;
                throw e;
            }
        }
    }

    private String jsonifyString(String str) {
        if (str == null) {
            str = "null";
        }
        if (str.length() > this.maxStringLength) {
            return JSONObject.quote((String)(str.substring(0, this.maxStringLength) + "..."));
        }
        return JSONObject.quote((String)str);
    }

    static enum Field {
        ROW_KEY,
        COUNT,
        NAMES,
        ROWS,
        COLUMN,
        TIMESTAMP,
        VALUE,
        TTL;

    }

    public static interface ErrorHandler {
        public boolean onException(Exception var1);
    }
}

