/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cli;

import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.CfDef;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexOperator;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.KsDef;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;

public class CliUtils {
    public static String unescapeSQLString(String b) {
        if (b.charAt(0) == '\'' && b.charAt(b.length() - 1) == '\'') {
            b = b.substring(1, b.length() - 1);
        }
        return StringEscapeUtils.unescapeJava((String)b);
    }

    public static String escapeSQLString(String b) {
        return StringEscapeUtils.escapeJava((String)b).replace("'", "\\'");
    }

    public static String maybeEscapeName(String name) {
        return Character.isLetter(name.charAt(0)) ? name : "'" + name + "'";
    }

    public static IndexOperator getIndexOperator(String operator) {
        if (operator.equals("=")) {
            return IndexOperator.EQ;
        }
        if (operator.equals(">=")) {
            return IndexOperator.GTE;
        }
        if (operator.equals(">")) {
            return IndexOperator.GT;
        }
        if (operator.equals("<")) {
            return IndexOperator.LT;
        }
        if (operator.equals("<=")) {
            return IndexOperator.LTE;
        }
        return null;
    }

    public static Set<String> getCfNamesByKeySpace(KsDef keySpace) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (CfDef cfDef : keySpace.getCf_defs()) {
            names.add(cfDef.getName());
        }
        return names;
    }

    public static KsDef getKeySpaceDef(String keyspaceName, List<KsDef> keyspaces) {
        keyspaceName = keyspaceName.toUpperCase();
        for (KsDef ksDef : keyspaces) {
            if (!ksDef.name.toUpperCase().equals(keyspaceName)) continue;
            return ksDef;
        }
        return null;
    }

    public static String quote(String str) {
        return String.format("'%s'", str);
    }
}

