/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3;

import com.google.common.collect.AbstractIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnSpecification;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ResultSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.BooleanType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DoubleType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.InetAddressType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.Int32Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ListType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LongType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.MapType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.SetType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TimestampType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.UTF8Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.UUIDType;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class UntypedResultSet
implements Iterable<Row> {
    private final ResultSet cqlRows;

    public UntypedResultSet(ResultSet cqlRows) {
        this.cqlRows = cqlRows;
    }

    public boolean isEmpty() {
        return this.cqlRows.size() == 0;
    }

    public int size() {
        return this.cqlRows.size();
    }

    public Row one() {
        if (this.cqlRows.rows.size() != 1) {
            throw new IllegalStateException("One row required, " + this.cqlRows.rows.size() + " found");
        }
        return new Row(this.cqlRows.metadata.names, this.cqlRows.rows.get(0));
    }

    @Override
    public Iterator<Row> iterator() {
        return new AbstractIterator<Row>(){
            Iterator<List<ByteBuffer>> iter;
            {
                this.iter = ((UntypedResultSet)UntypedResultSet.this).cqlRows.rows.iterator();
            }

            protected Row computeNext() {
                if (!this.iter.hasNext()) {
                    return (Row)this.endOfData();
                }
                return new Row(((UntypedResultSet)UntypedResultSet.this).cqlRows.metadata.names, this.iter.next());
            }
        };
    }

    public static class Row {
        private final Map<String, ByteBuffer> data = new HashMap<String, ByteBuffer>();
        private final List<ColumnSpecification> columns = new ArrayList<ColumnSpecification>();

        public Row(Map<String, ByteBuffer> data) {
            this.data.putAll(data);
        }

        public Row(List<ColumnSpecification> names, List<ByteBuffer> columns) {
            this.columns.addAll(names);
            for (int i = 0; i < names.size(); ++i) {
                this.data.put(names.get(i).toString(), columns.get(i));
            }
        }

        public boolean has(String column) {
            return this.data.get(column) != null;
        }

        public String getString(String column) {
            return (String)UTF8Type.instance.compose(this.data.get(column));
        }

        public boolean getBoolean(String column) {
            return (Boolean)BooleanType.instance.compose(this.data.get(column));
        }

        public int getInt(String column) {
            return (Integer)Int32Type.instance.compose(this.data.get(column));
        }

        public double getDouble(String column) {
            return (Double)DoubleType.instance.compose(this.data.get(column));
        }

        public ByteBuffer getBytes(String column) {
            return this.data.get(column);
        }

        public InetAddress getInetAddress(String column) {
            return (InetAddress)InetAddressType.instance.compose(this.data.get(column));
        }

        public UUID getUUID(String column) {
            return (UUID)UUIDType.instance.compose(this.data.get(column));
        }

        public Date getTimestamp(String column) {
            return (Date)TimestampType.instance.compose(this.data.get(column));
        }

        public long getLong(String column) {
            return (Long)LongType.instance.compose(this.data.get(column));
        }

        public <T> Set<T> getSet(String column, AbstractType<T> type) {
            ByteBuffer raw = this.data.get(column);
            return raw == null ? null : (Set)SetType.getInstance(type).compose(raw);
        }

        public <T> List<T> getList(String column, AbstractType<T> type) {
            ByteBuffer raw = this.data.get(column);
            return raw == null ? null : (List)ListType.getInstance(type).compose(raw);
        }

        public <K, V> Map<K, V> getMap(String column, AbstractType<K> keyType, AbstractType<V> valueType) {
            ByteBuffer raw = this.data.get(column);
            return raw == null ? null : (Map)MapType.getInstance(keyType, valueType).compose(raw);
        }

        public List<ColumnSpecification> getColumns() {
            return this.columns;
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

