/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnSpecification;
import java.util.Arrays;
import java.util.List;

public class VariableSpecifications {
    private final List<ColumnIdentifier> variableNames;
    private final ColumnSpecification[] specs;
    private int collectedCount;

    public VariableSpecifications(List<ColumnIdentifier> variableNames) {
        this.variableNames = variableNames;
        this.specs = new ColumnSpecification[variableNames.size()];
    }

    public int size() {
        return this.variableNames.size();
    }

    public List<ColumnSpecification> getSpecifications() {
        return Arrays.asList(this.specs);
    }

    public void add(int bindIndex, ColumnSpecification spec) {
        ColumnIdentifier name = this.variableNames.get(bindIndex);
        if (name != null) {
            spec = new ColumnSpecification(spec.ksName, spec.cfName, name, spec.type);
        }
        this.specs[bindIndex] = spec;
        ++this.collectedCount;
    }

    public int getCollectedCount() {
        return this.collectedCount;
    }
}

