/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFName;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQLStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryOptions;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.CFStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.ParsedStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;

public abstract class SchemaAlteringStatement
extends CFStatement
implements CQLStatement {
    private final boolean isColumnFamilyLevel;

    protected SchemaAlteringStatement() {
        super(null);
        this.isColumnFamilyLevel = false;
    }

    protected SchemaAlteringStatement(CFName name) {
        super(name);
        this.isColumnFamilyLevel = true;
    }

    @Override
    public int getBoundTerms() {
        return 0;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (this.isColumnFamilyLevel) {
            super.prepareKeyspace(state);
        }
    }

    @Override
    public ParsedStatement.Prepared prepare() {
        return new ParsedStatement.Prepared(this);
    }

    public abstract ResultMessage.SchemaChange.Change changeType();

    public abstract boolean announceMigration() throws RequestValidationException;

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws RequestValidationException {
        boolean didChangeSchema = this.announceMigration();
        if (!didChangeSchema) {
            return new ResultMessage.Void();
        }
        String tableName = this.cfName == null || this.columnFamily() == null ? "" : this.columnFamily();
        return new ResultMessage.SchemaChange(this.changeType(), this.keyspace(), tableName);
    }

    @Override
    public ResultMessage executeInternal(QueryState state, QueryOptions options) {
        throw new UnsupportedOperationException();
    }
}

