/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.google.common.base.Objects;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ColumnSlice;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.AbstractBounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.IPartitioner;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;

public class DataRange {
    protected final AbstractBounds<RowPosition> keyRange;
    protected IDiskAtomFilter columnFilter;
    protected final boolean selectFullRow;

    public DataRange(AbstractBounds<RowPosition> range, IDiskAtomFilter columnFilter) {
        this.keyRange = range;
        this.columnFilter = columnFilter;
        this.selectFullRow = columnFilter instanceof SliceQueryFilter ? DataRange.isFullRowSlice((SliceQueryFilter)columnFilter) : false;
    }

    public static boolean isFullRowSlice(SliceQueryFilter filter) {
        return filter.slices.length == 1 && filter.start().remaining() == 0 && filter.finish().remaining() == 0 && filter.count == Integer.MAX_VALUE;
    }

    public static DataRange allData(IPartitioner partitioner) {
        return DataRange.forKeyRange(new Range<Token>((Token)partitioner.getMinimumToken(), (Token)partitioner.getMinimumToken()));
    }

    public static DataRange forKeyRange(Range<Token> keyRange) {
        return new DataRange(keyRange.toRowBounds(), new IdentityQueryFilter());
    }

    public AbstractBounds<RowPosition> keyRange() {
        return this.keyRange;
    }

    public RowPosition startKey() {
        return (RowPosition)this.keyRange.left;
    }

    public RowPosition stopKey() {
        return (RowPosition)this.keyRange.right;
    }

    public boolean ignoredTombstonedPartitions() {
        if (!(this.columnFilter instanceof SliceQueryFilter)) {
            return false;
        }
        return ((SliceQueryFilter)this.columnFilter).compositesToGroup == -2;
    }

    public boolean isWrapAround() {
        return this.keyRange instanceof Range && ((Range)this.keyRange).isWrapAround();
    }

    public boolean contains(RowPosition pos) {
        return this.keyRange.contains(pos);
    }

    public int getLiveCount(ColumnFamily data, long now) {
        return this.columnFilter instanceof SliceQueryFilter ? ((SliceQueryFilter)this.columnFilter).lastCounted() : this.columnFilter.getLiveCount(data, now);
    }

    public boolean selectsFullRowFor(ByteBuffer rowKey) {
        return this.selectFullRow;
    }

    public IDiskAtomFilter columnFilter(ByteBuffer rowKey) {
        return this.columnFilter;
    }

    public void updateColumnsLimit(int count) {
        this.columnFilter.updateColumnsLimit(count);
    }

    public static class Paging
    extends DataRange {
        private final SliceQueryFilter sliceFilter;
        private final CFMetaData cfm;
        private final Comparator<ByteBuffer> comparator;
        private final ByteBuffer firstPartitionColumnStart;
        private final ByteBuffer lastPartitionColumnFinish;
        private ByteBuffer lastKeyFilterWasUpdatedFor;

        private Paging(AbstractBounds<RowPosition> range, SliceQueryFilter filter, ByteBuffer firstPartitionColumnStart, ByteBuffer lastPartitionColumnFinish, CFMetaData cfm, Comparator<ByteBuffer> comparator) {
            super(range, filter);
            assert (!(range instanceof Range) || !((Range)range).isWrapAround() || ((RowPosition)range.right).isMinimum()) : range;
            this.sliceFilter = filter;
            this.cfm = cfm;
            this.comparator = comparator;
            this.firstPartitionColumnStart = firstPartitionColumnStart;
            this.lastPartitionColumnFinish = lastPartitionColumnFinish;
            this.lastKeyFilterWasUpdatedFor = null;
        }

        public Paging(AbstractBounds<RowPosition> range, SliceQueryFilter filter, ByteBuffer columnStart, ByteBuffer columnFinish, CFMetaData cfm) {
            this(range, filter, columnStart, columnFinish, cfm, filter.isReversed() ? cfm.comparator.reverseComparator : cfm.comparator);
        }

        @Override
        public boolean selectsFullRowFor(ByteBuffer rowKey) {
            if (!this.selectFullRow) {
                return false;
            }
            if (!this.equals(this.startKey(), rowKey) && !this.equals(this.stopKey(), rowKey)) {
                return true;
            }
            return Paging.isFullRowSlice((SliceQueryFilter)this.columnFilter(rowKey));
        }

        private boolean equals(RowPosition pos, ByteBuffer rowKey) {
            return pos instanceof DecoratedKey && ((DecoratedKey)pos).key.equals(rowKey);
        }

        @Override
        public IDiskAtomFilter columnFilter(ByteBuffer rowKey) {
            if (this.equals(this.startKey(), rowKey) || this.equals(this.stopKey(), rowKey)) {
                if (!rowKey.equals(this.lastKeyFilterWasUpdatedFor)) {
                    this.lastKeyFilterWasUpdatedFor = rowKey;
                    this.columnFilter = this.sliceFilter.withUpdatedSlices(this.slicesForKey(rowKey));
                }
            } else {
                this.columnFilter = this.sliceFilter;
            }
            return this.columnFilter;
        }

        private boolean sliceIncludesStatics(ColumnSlice slice, boolean reversed, CFMetaData cfm) {
            return cfm.hasStaticColumns() && cfm.getStaticColumnNameBuilder().build().compareTo(reversed ? slice.finish : slice.start) >= 0;
        }

        private ColumnSlice[] slicesForKey(ByteBuffer key) {
            ByteBuffer newStart = this.equals(this.startKey(), key) && this.firstPartitionColumnStart.hasRemaining() ? this.firstPartitionColumnStart : null;
            ByteBuffer newFinish = this.equals(this.stopKey(), key) && this.lastPartitionColumnFinish.hasRemaining() ? this.lastPartitionColumnFinish : null;
            ArrayList<ColumnSlice> newSlices = new ArrayList<ColumnSlice>(this.sliceFilter.slices.length);
            for (ColumnSlice slice : this.sliceFilter.slices) {
                if (newStart != null) {
                    if (slice.isBefore(this.comparator, newStart)) {
                        if (this.sliceFilter.reversed || !this.sliceIncludesStatics(slice, false, this.cfm)) continue;
                        newSlices.add(new ColumnSlice(ByteBufferUtil.EMPTY_BYTE_BUFFER, this.cfm.getStaticColumnNameBuilder().buildAsEndOfRange()));
                        continue;
                    }
                    if (slice.includes(this.comparator, newStart)) {
                        if (!this.sliceFilter.reversed && this.sliceIncludesStatics(slice, false, this.cfm) && !newStart.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER)) {
                            newSlices.add(new ColumnSlice(ByteBufferUtil.EMPTY_BYTE_BUFFER, this.cfm.getStaticColumnNameBuilder().buildAsEndOfRange()));
                        }
                        slice = new ColumnSlice(newStart, slice.finish);
                    }
                    newStart = null;
                }
                assert (newStart == null);
                if (newFinish != null && !slice.isBefore(this.comparator, newFinish)) {
                    if (!slice.includes(this.comparator, newFinish)) break;
                    newSlices.add(new ColumnSlice(slice.start, newFinish));
                    break;
                }
                newSlices.add(slice);
            }
            return newSlices.toArray(new ColumnSlice[newSlices.size()]);
        }

        @Override
        public void updateColumnsLimit(int count) {
            this.columnFilter.updateColumnsLimit(count);
            this.sliceFilter.updateColumnsLimit(count);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("keyRange", (Object)this.keyRange).add("sliceFilter", (Object)this.sliceFilter).add("columnFilter", (Object)this.columnFilter).add("firstPartitionColumnStart", (Object)(this.firstPartitionColumnStart == null ? "null" : ByteBufferUtil.bytesToHex(this.firstPartitionColumnStart))).add("lastPartitionColumnFinish", (Object)(this.lastPartitionColumnFinish == null ? "null" : ByteBufferUtil.bytesToHex(this.lastPartitionColumnFinish))).toString();
        }
    }
}

